/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.plugins.workinghours.api.calendar.Calendar;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarBuilder;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarInfo;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarService;
import com.atlassian.jira.plugins.workinghours.api.calendar.HolidayBuilder;
import com.atlassian.jira.plugins.workinghours.api.calendar.Weekday;
import com.atlassian.jira.plugins.workinghours.api.calendar.WorkingTimeBuilder;
import com.atlassian.jira.plugins.workinghours.internal.rest.request.CalendarRequest;
import com.atlassian.jira.plugins.workinghours.internal.rest.request.HolidayRequest;
import com.atlassian.jira.plugins.workinghours.internal.rest.request.WorkingTimeRequest;
import com.atlassian.jira.plugins.workinghours.internal.rest.util.CalendarSerialiser;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.pocketknife.api.rest.AbstractRestResource;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

@Path(value="/api/calendar")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
public class CalendarResource
extends AbstractRestResource {
    private final CalendarService calendarService;
    private final CalendarSerialiser calendarSerialiser;

    public CalendarResource(JiraAuthenticationContext jiraAuthenticationContext, CalendarService calendarService, CalendarSerialiser calendarSerialiser) {
        super(CalendarResource.class, jiraAuthenticationContext);
        this.calendarService = calendarService;
        this.calendarSerialiser = calendarSerialiser;
    }

    @GET
    @Consumes(value={"application/json"})
    public Response getAllInfo(@QueryParam(value="filter") String filter) {
        final io.atlassian.fugue.Either<ErrorCollection, Map<String, String>> filterMap = CalendarResource.parseFilter(filter);
        if (filterMap.isLeft()) {
            return this.errorResponse("json.decode.failed", (ErrorCollection)filterMap.left().get());
        }
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                List<CalendarInfo> allByFilter = CalendarResource.this.calendarService.getAllInfosByFilter(CalendarResource.this.getUser(), (Map)filterMap.right().get());
                return CalendarResource.this.ok(CalendarResource.this.calendarSerialiser.fromCalendarInfos(allByFilter));
            }
        });
    }

    static io.atlassian.fugue.Either<ErrorCollection, Map<String, String>> parseFilter(String filter) {
        HashMap filterMap = Maps.newHashMap();
        if (filter == null) {
            return io.atlassian.fugue.Either.right((Object)filterMap);
        }
        try {
            JSONObject jsonObject = new JSONObject(filter);
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = jsonObject.getString(key);
                filterMap.put(key, value);
            }
            return io.atlassian.fugue.Either.right((Object)filterMap);
        }
        catch (JSONException e) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"workinghours.error.filter.decode.failed", (Object[])new Object[]{e.getMessage()}));
        }
    }

    @GET
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    public Response getById(@PathParam(value="id") int id) {
        return this.response(() -> {
            io.atlassian.fugue.Either result = StepsConverters.newerEither(this.calendarService.get(this.getUser(), id));
            if (result.isLeft()) {
                return this.errorResponse("calendar.get.failed", (ErrorCollection)result.left().get());
            }
            return this.ok(this.calendarSerialiser.fromCalendar(this.getUser(), (Calendar)result.right().get()));
        });
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createCalendar(final CalendarRequest request) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                io.atlassian.fugue.Either conversionResult = CalendarResource.this.buildCalendarFromRequest(request);
                if (conversionResult.isLeft()) {
                    return (Response)conversionResult.left().get();
                }
                io.atlassian.fugue.Either createResult = StepsConverters.newerEither(CalendarResource.this.calendarService.create(CalendarResource.this.getUser(), (Calendar)conversionResult.right().get()));
                if (createResult.isLeft()) {
                    return CalendarResource.this.errorResponse("calendar.create.failed", (ErrorCollection)createResult.left().get());
                }
                return CalendarResource.this.ok(CalendarResource.this.calendarSerialiser.fromCalendar(CalendarResource.this.getUser(), (Calendar)createResult.right().get()));
            }
        });
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    public Response updateCalendar(CalendarRequest request, @PathParam(value="id") int id) {
        return this.response(() -> {
            io.atlassian.fugue.Either<Response, Calendar> conversionResult = this.buildCalendarFromRequest(request, id);
            if (conversionResult.isLeft()) {
                return (Response)conversionResult.left().get();
            }
            io.atlassian.fugue.Either updateResult = StepsConverters.newerEither(this.calendarService.update(this.getUser(), (Calendar)conversionResult.right().get()));
            if (updateResult.isLeft()) {
                return this.errorResponse("calendar.update.failed", (ErrorCollection)updateResult.left().get());
            }
            return this.ok(this.calendarSerialiser.fromCalendar(this.getUser(), (Calendar)updateResult.right().get()));
        });
    }

    @DELETE
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    public Response deleteCalendar(@PathParam(value="id") int id) {
        return this.response(() -> {
            io.atlassian.fugue.Either updateResult = StepsConverters.newerEither(this.calendarService.delete(this.getUser(), id)).map(StepsConverters::newerOption);
            if (updateResult.isLeft()) {
                return this.errorResponse("calendar.delete.failed", (ErrorCollection)updateResult.left().get());
            }
            return this.noContent();
        });
    }

    private io.atlassian.fugue.Either<Response, Calendar> buildCalendarFromRequest(CalendarRequest request) {
        return this.buildCalendarFromRequest(request, null);
    }

    private io.atlassian.fugue.Either<Response, Calendar> buildCalendarFromRequest(CalendarRequest request, Integer id) {
        CalendarBuilder builder = CalendarBuilder.builder().id(id).name(request.getName()).context(request.getContext());
        try {
            builder.timezone(DateTimeZone.forID((String)request.getTimezoneId()));
        }
        catch (IllegalArgumentException e) {
            return io.atlassian.fugue.Either.left((Object)this.badRequest("calendar.invalid.timezone", this.jiraAuthenticationContext.getI18nHelper().getText("workinghours.validation.failure.timezone.unknown"), "timezone"));
        }
        try {
            this.buildAndAddHolidaysToCalendar(request.getHolidays(), builder);
        }
        catch (IllegalArgumentException e) {
            return io.atlassian.fugue.Either.left((Object)this.badRequest("calendar.invalid.holiday", e.getMessage(), "holidays"));
        }
        if (request.getWorkingTimes() != null) {
            for (WorkingTimeRequest wtr : request.getWorkingTimes()) {
                Weekday weekday = Weekday.byName(wtr.getWeekday());
                if (weekday == null) {
                    return io.atlassian.fugue.Either.left((Object)this.badRequest("calendar.invalid.weekday", "invalid weekday value: " + wtr.getWeekday(), "workweek"));
                }
                builder.addWorkingTime(WorkingTimeBuilder.builder().weekday(weekday).start(wtr.getStart()).end(wtr.getEnd()).build());
            }
        }
        return io.atlassian.fugue.Either.right((Object)builder.build());
    }

    @VisibleForTesting
    protected void buildAndAddHolidaysToCalendar(List<HolidayRequest> holidays, CalendarBuilder builder) {
        if (holidays != null) {
            this.sortHolidaysByDate(holidays);
            for (HolidayRequest hr : holidays) {
                LocalDate date = this.calendarSerialiser.dateFromString(hr.getDate());
                builder.addHoliday(HolidayBuilder.builder().name(hr.getName()).date(date).recurring(hr.getRecurring() != null ? hr.getRecurring() : false).build());
            }
        }
    }

    private void sortHolidaysByDate(List<HolidayRequest> holidays) {
        holidays.sort(Comparator.comparing(h -> this.calendarSerialiser.dateFromString(h.getDate())));
    }
}

