/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.calendar.dao;

import com.atlassian.jira.plugins.workinghours.api.calendar.Holiday;
import com.atlassian.jira.plugins.workinghours.api.calendar.HolidayBuilder;
import com.atlassian.jira.plugins.workinghours.internal.ao.schema.current.WorkingHoursDbSchema;
import com.atlassian.pocketknife.api.ao.dao.RelatedAOMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joda.time.LocalDate;
import org.springframework.stereotype.Component;

@Component
public class HolidayAOMapper
implements RelatedAOMapper<WorkingHoursDbSchema.CalendarAO, WorkingHoursDbSchema.HolidayAO, Holiday> {
    public static final String CALENDAR_ID_COL = "CALENDAR_ID";
    public static final String DATE_STRING_COL = "DATE_STRING";
    public static final String RECURRING_COL = "RECURRING";
    public static final String NAME_COL = "NAME";

    public Map<String, Object> toAO(WorkingHoursDbSchema.CalendarAO calendarAO, Holiday holiday) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.toAO(holiday));
        map.put(CALENDAR_ID_COL, calendarAO);
        return map;
    }

    public Map<String, Object> toAO(Holiday holiday) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(DATE_STRING_COL, HolidayAOMapper.dateToString(holiday.getDate()));
        map.put(NAME_COL, holiday.getName());
        map.put(RECURRING_COL, holiday.isRecurring());
        return map;
    }

    public Holiday toModel(WorkingHoursDbSchema.HolidayAO holidayAO) {
        HolidayBuilder builder = HolidayBuilder.builder();
        builder.date(HolidayAOMapper.fromDateString(holidayAO.getDateString()));
        builder.name(StringUtils.defaultString((String)holidayAO.getName()));
        builder.recurring(holidayAO.getRecurring());
        return builder.build();
    }

    public void update(Holiday holiday, WorkingHoursDbSchema.HolidayAO holidayAO) {
        holidayAO.setDateString(HolidayAOMapper.dateToString(holiday.getDate()));
        holidayAO.setName(holiday.getName());
        holidayAO.setRecurring(holiday.isRecurring());
    }

    public List<Holiday> toModel(List<WorkingHoursDbSchema.HolidayAO> holidayAOs) {
        ArrayList<Holiday> models = new ArrayList<Holiday>(holidayAOs.size());
        for (WorkingHoursDbSchema.HolidayAO holidayAO : holidayAOs) {
            models.add(this.toModel(holidayAO));
        }
        return models;
    }

    static String dateToString(LocalDate localDate) {
        return localDate.toString();
    }

    static LocalDate fromDateString(String dateString) {
        return LocalDate.parse((String)dateString);
    }
}

