/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.calendar.dao;

import com.atlassian.fugue.Either;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarInfo;
import com.atlassian.jira.plugins.workinghours.internal.ao.schema.current.WorkingHoursDbSchema;
import com.atlassian.jira.plugins.workinghours.internal.calendar.dao.CalendarAOMapper;
import com.atlassian.jira.plugins.workinghours.internal.calendar.dao.HolidayDao;
import com.atlassian.jira.plugins.workinghours.internal.calendar.dao.WorkingTimeDao;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.util.collect.Consumer;
import com.atlassian.pocketknife.api.ao.dao.GenericActiveObjectsDao;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CalendarDao
extends GenericActiveObjectsDao<Integer, WorkingHoursDbSchema.CalendarAO> {
    @Autowired
    private CalendarAOMapper calendarAOMapper;
    @Autowired
    private WorkingTimeDao workingTimeDao;
    @Autowired
    private HolidayDao holidayDao;

    public List<CalendarInfo> getAll() {
        ArrayList calendarInfos = Lists.newArrayList();
        Consumer consumer = calendarAO -> {
            CalendarInfo calendarInfo = this.calendarAOMapper.toModel((WorkingHoursDbSchema.CalendarAO)calendarAO);
            if (calendarInfo != null) {
                calendarInfos.add(calendarInfo);
            }
        };
        this.ao.stream(WorkingHoursDbSchema.CalendarAO.class, arg_0 -> ((Consumer)consumer).consume(arg_0));
        return calendarInfos;
    }

    public void delete(Integer primaryKey) {
        this.log.debug("deleting entity of type %s with primary key = %s", new Object[]{this.entityType.getName(), primaryKey});
        WorkingHoursDbSchema.CalendarAO entity = (WorkingHoursDbSchema.CalendarAO)this.ao.get(this.entityType, (Object)primaryKey);
        if (entity != null) {
            this.delete((RawEntity[])new WorkingHoursDbSchema.CalendarAO[]{entity});
        }
    }

    protected void preDelete(WorkingHoursDbSchema.CalendarAO ... calendars) {
        for (WorkingHoursDbSchema.CalendarAO calendarAO : calendars) {
            this.workingTimeDao.delete((RawEntity[])calendarAO.getWorkingTimes());
            this.holidayDao.delete((RawEntity[])calendarAO.getHolidays());
        }
    }

    public io.atlassian.fugue.Either<ErrorCollection, WorkingHoursDbSchema.CalendarAO> update(CalendarInfo calendarInfo) {
        WorkingHoursDbSchema.CalendarAO calendarAO = (WorkingHoursDbSchema.CalendarAO)this.ao.get(WorkingHoursDbSchema.CalendarAO.class, (Object)calendarInfo.getId());
        if (calendarAO == null) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"Calendar with id {0} not found", (Object[])new Object[]{calendarInfo.getId()}));
        }
        this.calendarAOMapper.update(calendarInfo, calendarAO);
        calendarAO.save();
        return io.atlassian.fugue.Either.right((Object)calendarAO);
    }
}

