/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.calendar;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.plugins.workinghours.api.calendar.Calendar;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarInfo;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarManager;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarService;
import com.atlassian.jira.plugins.workinghours.api.calendar.access.CalendarAccessManager;
import com.atlassian.jira.plugins.workinghours.api.calendar.access.Operation;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class CalendarServiceImpl
implements CalendarService {
    @Autowired
    private CalendarManager calendarManager;
    @Autowired
    private CalendarAccessManager calendarAccessManager;

    @Override
    public Either<ErrorCollection, CalendarInfo> getInfo(ApplicationUser user, int id) {
        io.atlassian.fugue.Either calendarInfo = StepsConverters.newerEither(this.calendarManager.getInfo(id));
        if (calendarInfo.isLeft()) {
            return ServiceResult.error((ErrorCollection)((ErrorCollection)calendarInfo.left().get()));
        }
        if (!this.calendarAccessManager.hasPermission(user, ((CalendarInfo)calendarInfo.right().get()).getContext(), Operation.VIEW)) {
            return ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"workinghours.error.no.view.permission", (Object[])new Object[0]);
        }
        return StepsConverters.olderEither((io.atlassian.fugue.Either)calendarInfo);
    }

    @Override
    public List<CalendarInfo> getAllInfos(ApplicationUser user) {
        return this.getAllInfosByFilter(user, Maps.newHashMap());
    }

    @Override
    public List<CalendarInfo> getAllInfosByFilter(ApplicationUser user, Map<String, String> filter) {
        List<CalendarInfo> infos = this.calendarManager.getAllInfos();
        this.applyFilter(user, filter, infos);
        this.applyViewPermission(user, infos);
        return infos;
    }

    @Override
    public Either<ErrorCollection, Calendar> get(ApplicationUser user, int id) {
        io.atlassian.fugue.Either calendar = StepsConverters.newerEither(this.calendarManager.get(id));
        if (calendar.isLeft()) {
            return ServiceResult.error((ErrorCollection)((ErrorCollection)calendar.left().get()));
        }
        if (!this.calendarAccessManager.hasPermission(user, ((Calendar)calendar.right().get()).getContext(), Operation.VIEW)) {
            return ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"workinghours.error.no.view.permission", (Object[])new Object[0]);
        }
        return StepsConverters.olderEither((io.atlassian.fugue.Either)calendar);
    }

    @Override
    public List<Calendar> getAll(ApplicationUser user) {
        return this.getAllByFilter(user, Maps.newHashMap());
    }

    @Override
    public List<Calendar> getAllByFilter(ApplicationUser user, Map<String, String> filter) {
        List<CalendarInfo> infos = this.getAllInfosByFilter(user, filter);
        ArrayList calendars = Lists.newArrayList();
        for (CalendarInfo info : infos) {
            io.atlassian.fugue.Either fromInfo = StepsConverters.newerEither(this.calendarManager.getFromInfo(info));
            if (!fromInfo.isRight()) continue;
            calendars.add(fromInfo.right().get());
        }
        return calendars;
    }

    @Override
    public Either<ErrorCollection, Calendar> create(ApplicationUser user, Calendar calendar) {
        if (!this.calendarAccessManager.hasPermission(user, calendar.getContext(), Operation.CREATE)) {
            return ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"workinghours.error.no.create.permission", (Object[])new Object[0]);
        }
        io.atlassian.fugue.Either errors = StepsConverters.newerEither(this.calendarAccessManager.validate(user, calendar, Operation.CREATE)).map(StepsConverters::newerOption);
        if (errors.isLeft()) {
            return ServiceResult.error((ErrorCollection)((ErrorCollection)errors.left().get()));
        }
        return this.calendarManager.create(calendar);
    }

    @Override
    public Either<ErrorCollection, Calendar> update(ApplicationUser user, Calendar calendar) {
        io.atlassian.fugue.Either existingCalendar = StepsConverters.newerEither(this.calendarManager.get(calendar.getId()));
        if (existingCalendar.isLeft()) {
            return ServiceResult.error((ErrorCollection)((ErrorCollection)existingCalendar.left().get()));
        }
        if (!this.calendarAccessManager.hasPermission(user, ((Calendar)existingCalendar.right().get()).getContext(), Operation.UPDATE)) {
            return ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"workinghours.error.no.edit.permission", (Object[])new Object[0]);
        }
        io.atlassian.fugue.Either errors = StepsConverters.newerEither(this.calendarAccessManager.validate(user, calendar, Operation.UPDATE)).map(StepsConverters::newerOption);
        if (errors.isLeft()) {
            return ServiceResult.error((ErrorCollection)((ErrorCollection)errors.left().get()));
        }
        return this.calendarManager.update(calendar);
    }

    @Override
    public Either<ErrorCollection, Option<Object>> delete(ApplicationUser user, int id) {
        io.atlassian.fugue.Either existingCalendar = StepsConverters.newerEither(this.calendarManager.get(id));
        if (existingCalendar.isLeft()) {
            return ServiceResult.error((ErrorCollection)((ErrorCollection)existingCalendar.left().get()));
        }
        if (!this.calendarAccessManager.hasPermission(user, ((Calendar)existingCalendar.right().get()).getContext(), Operation.DELETE)) {
            return ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"workinghours.error.no.delete.permission", (Object[])new Object[0]);
        }
        io.atlassian.fugue.Either errors = StepsConverters.newerEither(this.calendarAccessManager.validate(user, (Calendar)existingCalendar.right().get(), Operation.DELETE)).map(StepsConverters::newerOption);
        if (errors.isLeft()) {
            return ServiceResult.error((ErrorCollection)((ErrorCollection)errors.left().get()));
        }
        return this.calendarManager.delete(id);
    }

    @Override
    public int getCalendarNameLimit() {
        return this.calendarManager.getCalendarNameLimit();
    }

    private void applyViewPermission(ApplicationUser user, List<CalendarInfo> infos) {
        Iterator<CalendarInfo> it = infos.iterator();
        while (it.hasNext()) {
            CalendarInfo info = it.next();
            if (this.calendarAccessManager.hasPermission(user, info.getContext(), Operation.VIEW)) continue;
            it.remove();
        }
    }

    private void applyFilter(ApplicationUser user, Map<String, String> filter, List<CalendarInfo> infos) {
        Iterator<CalendarInfo> it = infos.iterator();
        while (it.hasNext()) {
            CalendarInfo info = it.next();
            if (this.calendarAccessManager.matchesFilter(user, info, filter)) continue;
            it.remove();
        }
    }
}

