/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.calendar;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.plugins.workinghours.api.calendar.Calendar;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarBuilder;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarInfo;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarManager;
import com.atlassian.jira.plugins.workinghours.api.calendar.Holiday;
import com.atlassian.jira.plugins.workinghours.api.calendar.HolidayBuilder;
import com.atlassian.jira.plugins.workinghours.api.calendar.HolidayService;
import com.atlassian.jira.plugins.workinghours.api.calendar.WorkingTime;
import com.atlassian.jira.plugins.workinghours.api.calendar.event.CalendarCreatedEvent;
import com.atlassian.jira.plugins.workinghours.api.calendar.event.CalendarDeletedEvent;
import com.atlassian.jira.plugins.workinghours.api.calendar.event.CalendarUpdatedEvent;
import com.atlassian.jira.plugins.workinghours.internal.ao.schema.current.WorkingHoursDbSchema;
import com.atlassian.jira.plugins.workinghours.internal.calendar.dao.CalendarAOMapper;
import com.atlassian.jira.plugins.workinghours.internal.calendar.dao.CalendarDao;
import com.atlassian.jira.plugins.workinghours.internal.calendar.dao.HolidayAOMapper;
import com.atlassian.jira.plugins.workinghours.internal.calendar.dao.HolidayDao;
import com.atlassian.jira.plugins.workinghours.internal.calendar.dao.WorkingTimeAOMapper;
import com.atlassian.jira.plugins.workinghours.internal.calendar.dao.WorkingTimeDao;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.VCacheFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CalendarManagerImpl
implements CalendarManager {
    private final CalendarDao calendarDao;
    private final WorkingTimeDao workingTimeDao;
    private final HolidayDao holidayDao;
    private final CalendarAOMapper calendarAOMapper;
    private final WorkingTimeAOMapper workingTimeAOMapper;
    private final HolidayAOMapper holidayAOMapper;
    private final EventPublisher eventPublisher;
    private final RequestCache<Integer, io.atlassian.fugue.Option<Calendar>> calendarCache;
    private final HolidayService holidayService;

    @Autowired
    public CalendarManagerImpl(CalendarDao calendarDao, WorkingTimeDao workingTimeDao, HolidayDao holidayDao, CalendarAOMapper calendarAOMapper, WorkingTimeAOMapper workingTimeAOMapper, HolidayAOMapper holidayAOMapper, EventPublisher eventPublisher, VCacheFactory cacheFactory, HolidayService holidayService) {
        this.calendarDao = calendarDao;
        this.workingTimeDao = workingTimeDao;
        this.holidayDao = holidayDao;
        this.calendarAOMapper = calendarAOMapper;
        this.workingTimeAOMapper = workingTimeAOMapper;
        this.holidayAOMapper = holidayAOMapper;
        this.eventPublisher = eventPublisher;
        this.calendarCache = cacheFactory.getRequestCache(this.getClass().getName() + ".calendarCache");
        this.holidayService = holidayService;
    }

    @Override
    public Either<ErrorCollection, CalendarInfo> getInfo(int id) {
        io.atlassian.fugue.Option<Calendar> calendar = this.getCalendarFromCache(id);
        if (calendar.isEmpty()) {
            return ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"workinghours.error.calendar.does.not.exist", (Object[])new Object[0]);
        }
        return ServiceResult.ok((Object)calendar.get());
    }

    @Override
    public List<CalendarInfo> getAllInfos() {
        return this.calendarDao.getAll();
    }

    @Override
    public Either<ErrorCollection, Calendar> get(int id) {
        io.atlassian.fugue.Option<Calendar> calendar = this.getCalendarFromCache(id);
        if (calendar.isEmpty()) {
            return ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"workinghours.error.calendar.does.not.exist", (Object[])new Object[0]);
        }
        return ServiceResult.ok((Object)calendar.get());
    }

    private io.atlassian.fugue.Option<Calendar> getCalendarFromCache(int id) {
        return (io.atlassian.fugue.Option)this.calendarCache.get((Object)id, () -> this.getCalendarFromDB(id));
    }

    private io.atlassian.fugue.Option<Calendar> getCalendarFromDB(int id) {
        io.atlassian.fugue.Either calendarAO = StepsConverters.newerEither((Either)this.calendarDao.load(id));
        if (calendarAO.isLeft()) {
            return io.atlassian.fugue.Option.none();
        }
        CalendarInfo calendarInfo = this.calendarAOMapper.toModel((WorkingHoursDbSchema.CalendarAO)calendarAO.right().get());
        return io.atlassian.fugue.Option.some((Object)this.loadFully(calendarInfo));
    }

    private Calendar loadFully(CalendarInfo calendarInfo) {
        Object[] workingTimeAOs = this.workingTimeDao.getForParent(calendarInfo.getId());
        List<WorkingTime> workingTimes = this.workingTimeAOMapper.toModel(Lists.newArrayList((Object[])workingTimeAOs));
        Object[] holidayAOs = this.holidayDao.getForParent(calendarInfo.getId());
        List<Holiday> holidays = this.holidayAOMapper.toModel(Lists.newArrayList((Object[])holidayAOs));
        return CalendarBuilder.builder(calendarInfo).holidays(holidays).workingTimes(workingTimes).build();
    }

    @Override
    public Either<ErrorCollection, Calendar> getFromInfo(CalendarInfo info) {
        return this.get(info.getId());
    }

    @Override
    public Either<ErrorCollection, Calendar> create(Calendar calendar) {
        io.atlassian.fugue.Either<ErrorCollection, Calendar> validate = this.validate(calendar);
        if (validate.isLeft()) {
            return ServiceResult.error((ErrorCollection)((ErrorCollection)validate.left().get()));
        }
        calendar = (Calendar)validate.right().get();
        WorkingHoursDbSchema.CalendarAO calendarAO = (WorkingHoursDbSchema.CalendarAO)this.calendarDao.create(this.calendarAOMapper.toAO(calendar));
        List<WorkingHoursDbSchema.HolidayAO> holidayAOs = this.holidayDao.updateForParent(calendarAO, calendar.getHolidays());
        List<WorkingHoursDbSchema.WorkingTimeAO> workingTimeAOs = this.workingTimeDao.updateForParent(calendarAO, calendar.getWorkingTimes());
        Calendar createdCalendar = this.toModel(calendarAO, workingTimeAOs, holidayAOs);
        this.calendarCache.remove((Object)calendarAO.getID());
        this.eventPublisher.publish((Object)new CalendarCreatedEvent(createdCalendar));
        return ServiceResult.ok((Object)createdCalendar);
    }

    @Override
    public Either<ErrorCollection, Calendar> update(Calendar calendar) {
        io.atlassian.fugue.Either<ErrorCollection, Calendar> validate = this.validate(calendar);
        if (validate.isLeft()) {
            return ServiceResult.error((ErrorCollection)((ErrorCollection)validate.left().get()));
        }
        calendar = (Calendar)validate.right().get();
        io.atlassian.fugue.Either<ErrorCollection, WorkingHoursDbSchema.CalendarAO> calendarAO = this.calendarDao.update(calendar);
        if (calendarAO.isLeft()) {
            return ServiceResult.error((ErrorCollection)((ErrorCollection)calendarAO.left().get()));
        }
        List<WorkingHoursDbSchema.WorkingTimeAO> workingTimeAOs = this.workingTimeDao.updateForParent((WorkingHoursDbSchema.CalendarAO)calendarAO.right().get(), calendar.getWorkingTimes());
        List<WorkingHoursDbSchema.HolidayAO> holidayAOs = this.holidayDao.updateForParent((WorkingHoursDbSchema.CalendarAO)calendarAO.right().get(), calendar.getHolidays());
        Calendar updatedCalendar = this.toModel((WorkingHoursDbSchema.CalendarAO)calendarAO.right().get(), workingTimeAOs, holidayAOs);
        this.calendarCache.remove((Object)updatedCalendar.getId());
        this.eventPublisher.publish((Object)new CalendarUpdatedEvent(updatedCalendar));
        return ServiceResult.ok((Object)updatedCalendar);
    }

    @Override
    public Either<ErrorCollection, Option<Object>> delete(int id) {
        Either<ErrorCollection, Calendar> calendarEither = this.get(id);
        if (calendarEither.isLeft()) {
            return ServiceResult.error(calendarEither);
        }
        Calendar calendar = (Calendar)calendarEither.right().get();
        this.calendarDao.delete(calendar.getId());
        this.calendarCache.remove((Object)calendar.getId());
        this.eventPublisher.publish((Object)new CalendarDeletedEvent(calendar));
        return ServiceResult.ok();
    }

    @Override
    public int getCalendarNameLimit() {
        return 63;
    }

    private Calendar toModel(WorkingHoursDbSchema.CalendarAO calendarAO, List<WorkingHoursDbSchema.WorkingTimeAO> workingTimeAOs, List<WorkingHoursDbSchema.HolidayAO> holidayAOs) {
        CalendarInfo calendarInfo = this.calendarAOMapper.toModel(calendarAO);
        List<WorkingTime> workingTimes = this.workingTimeAOMapper.toModel(workingTimeAOs);
        List<Holiday> holidays = this.holidayAOMapper.toModel(holidayAOs);
        return CalendarBuilder.builder(calendarInfo).holidays(holidays).workingTimes(workingTimes).build();
    }

    private io.atlassian.fugue.Either<ErrorCollection, Calendar> validate(Calendar calendar) {
        CalendarBuilder builder = CalendarBuilder.builder(calendar);
        String name = StringUtils.defaultString((String)calendar.getName());
        String trimmedName = name.trim();
        if (trimmedName.isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((String)"name", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"workinghours.validation.failure.name.empty", (Object[])new Object[0]));
        }
        if (trimmedName.length() > this.getCalendarNameLimit()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((String)"name", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"workinghours.validation.failure.name.long", (Object[])new Object[0]));
        }
        builder.name(trimmedName);
        if (calendar.getTimeZone() == null) {
            return StepsConverters.newerEither((Either)ServiceResult.error((String)"timezone", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"workinghours.validation.failure.timezone.empty", (Object[])new Object[0]));
        }
        for (WorkingTime workingTime : calendar.getWorkingTimes()) {
            if (workingTime.getWeekday() == null) {
                return StepsConverters.newerEither((Either)ServiceResult.error((String)"workweek", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"workinghours.validation.failure.workingtime.weekday.empty", (Object[])new Object[0]));
            }
            if (workingTime.getStart() == null) {
                return StepsConverters.newerEither((Either)ServiceResult.error((String)"workweek", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"workinghours.validation.failure.workingtime.start.empty", (Object[])new Object[0]));
            }
            if (workingTime.getEnd() == null) {
                return StepsConverters.newerEither((Either)ServiceResult.error((String)"workweek", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"workinghours.validation.failure.workingtime.end.empty", (Object[])new Object[0]));
            }
            if (workingTime.getStart() < workingTime.getEnd()) continue;
            return StepsConverters.newerEither((Either)ServiceResult.error((String)"workweek", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"workinghours.validation.failure.workingtime.invalid.time", (Object[])new Object[0]));
        }
        ArrayList copy = Lists.newArrayList();
        for (Holiday holiday : calendar.getHolidays()) {
            String holidayName = StringUtils.defaultString((String)holiday.getName()).trim();
            if (holidayName.isEmpty()) {
                return StepsConverters.newerEither((Either)ServiceResult.error((String)"holidays", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"workinghours.validation.failure.holidays.name.empty", (Object[])new Object[0]));
            }
            if (holidayName.length() > this.holidayService.getHolidayNameLimit()) {
                return StepsConverters.newerEither((Either)ServiceResult.error((String)"holidays", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"workinghours.validation.failure.holidays.name.long", (Object[])new Object[0]));
            }
            if (holiday.getDate() == null) {
                return StepsConverters.newerEither((Either)ServiceResult.error((String)"holidays", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"workinghours.validation.failure.holidays.date.empty", (Object[])new Object[0]));
            }
            if (holidayName.equals(holiday.getName())) {
                copy.add(holiday);
                continue;
            }
            copy.add(HolidayBuilder.builder(holiday).name(holidayName).build());
        }
        builder.holidays(copy);
        return io.atlassian.fugue.Either.right((Object)builder.build());
    }
}

