/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.calculator;

import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculator;
import com.atlassian.jira.plugins.workinghours.api.calendar.Calendar;
import com.atlassian.jira.plugins.workinghours.api.calendar.Holiday;
import com.atlassian.jira.plugins.workinghours.api.calendar.WorkingTime;
import com.atlassian.jira.plugins.workinghours.internal.calculator.ActiveRangesCalculator;
import com.atlassian.jira.plugins.workinghours.internal.calculator.DayTime;
import com.atlassian.jira.plugins.workinghours.internal.calculator.DayTimeRange;
import com.atlassian.jira.plugins.workinghours.internal.calculator.DayTimeRanges;
import com.atlassian.jira.plugins.workinghours.internal.calculator.OffDays;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.LocalDate;

public class WorkingHoursCalculatorImpl
implements WorkingHoursCalculator {
    private Calendar calendar;
    private ActiveRangesCalculator rangesCalculator;

    public WorkingHoursCalculatorImpl(Calendar calendar) {
        this.calendar = calendar;
        this.rangesCalculator = this.createCalculator(calendar);
    }

    @Override
    public Integer getId() {
        return this.calendar.getId();
    }

    @Override
    public String getName() {
        return this.calendar.getName();
    }

    @Override
    public DateTimeZone getTimeZone() {
        return this.calendar.getTimeZone();
    }

    @Override
    public boolean exceedsMaximumRange(Interval interval) {
        return this.rangesCalculator.exceedsMaximumRange(interval);
    }

    @Override
    public List<Interval> getActiveRanges(Interval checkRange) {
        return this.rangesCalculator.getActiveRanges(checkRange);
    }

    @Override
    public List<Interval> getActiveRanges(DateTime startDate, long duration) {
        return this.rangesCalculator.getActiveRanges(startDate, duration);
    }

    @Override
    public List<Interval> getIntervalsForDay(LocalDate day, DateTime lowerBoundary, DateTime upperBoundary) {
        return this.rangesCalculator.getIntervalsForDay(day, lowerBoundary, upperBoundary);
    }

    @Override
    public boolean isActive(DateTime dateTime) {
        return this.rangesCalculator.isActive(dateTime);
    }

    private ActiveRangesCalculator createCalculator(Calendar calendar) {
        ArrayList monday = Lists.newArrayList();
        ArrayList tuesday = Lists.newArrayList();
        ArrayList wednesday = Lists.newArrayList();
        ArrayList thursday = Lists.newArrayList();
        ArrayList friday = Lists.newArrayList();
        ArrayList saturday = Lists.newArrayList();
        ArrayList sunday = Lists.newArrayList();
        for (WorkingTime time : calendar.getWorkingTimes()) {
            DayTimeRange dayTimeRange = new DayTimeRange(DayTime.fromTimeInMillis(time.getStart()), DayTime.fromTimeInMillis(time.getEnd()));
            switch (time.getWeekday()) {
                case MONDAY: {
                    monday.add(dayTimeRange);
                    break;
                }
                case TUESDAY: {
                    tuesday.add(dayTimeRange);
                    break;
                }
                case WEDNESDAY: {
                    wednesday.add(dayTimeRange);
                    break;
                }
                case THURSDAY: {
                    thursday.add(dayTimeRange);
                    break;
                }
                case FRIDAY: {
                    friday.add(dayTimeRange);
                    break;
                }
                case SATURDAY: {
                    saturday.add(dayTimeRange);
                    break;
                }
                case SUNDAY: {
                    sunday.add(dayTimeRange);
                }
            }
        }
        OffDays offDays = new OffDays();
        for (Holiday holiday : calendar.getHolidays()) {
            offDays.add(holiday.getDate(), holiday.isRecurring());
        }
        return new ActiveRangesCalculator(calendar.getTimeZone(), new DayTimeRanges(monday), new DayTimeRanges(tuesday), new DayTimeRanges(wednesday), new DayTimeRanges(thursday), new DayTimeRanges(friday), new DayTimeRanges(saturday), new DayTimeRanges(sunday), offDays);
    }
}

