/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.calculator;

import com.google.common.collect.Sets;
import java.util.Set;
import org.joda.time.LocalDate;

public class OffDays {
    private Set<String> offDays = Sets.newHashSet();

    public void add(LocalDate localDate, boolean recurring) {
        String iso8061 = localDate.toString();
        if (recurring) {
            this.offDays.add(this.withoutYear(iso8061));
        } else {
            this.offDays.add(iso8061);
        }
    }

    public boolean isOffDay(LocalDate date) {
        String withYear = date.toString();
        if (this.offDays.contains(withYear)) {
            return true;
        }
        String withoutYear = this.withoutYear(withYear);
        return this.offDays.contains(withoutYear);
    }

    private String withoutYear(String iso8061) {
        return iso8061.substring(5);
    }
}

