/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.calculator;

import com.atlassian.jira.plugins.workinghours.internal.calculator.DayTime;
import com.atlassian.jira.plugins.workinghours.internal.calculator.DayTimeRange;
import com.atlassian.jira.plugins.workinghours.internal.calculator.DayTimeRanges;
import com.atlassian.jira.plugins.workinghours.internal.calculator.OffDays;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;

public class ActiveRangesCalculator {
    private static final int MAX_DAY_COUNT = 1500;
    private OffDays offDays;
    private DateTimeZone dateTimeZone;
    private DayTimeRanges[] rangesPerWeekday;

    public ActiveRangesCalculator(DateTimeZone dateTimeZone, DayTimeRanges monday, DayTimeRanges tuesday, DayTimeRanges wednesday, DayTimeRanges thursday, DayTimeRanges friday, DayTimeRanges saturday, DayTimeRanges sunday, OffDays offDays) {
        this.dateTimeZone = dateTimeZone;
        this.offDays = offDays;
        this.rangesPerWeekday = new DayTimeRanges[8];
        this.rangesPerWeekday[0] = null;
        this.rangesPerWeekday[1] = monday;
        this.rangesPerWeekday[2] = tuesday;
        this.rangesPerWeekday[3] = wednesday;
        this.rangesPerWeekday[4] = thursday;
        this.rangesPerWeekday[5] = friday;
        this.rangesPerWeekday[6] = saturday;
        this.rangesPerWeekday[7] = sunday;
    }

    public boolean exceedsMaximumRange(Interval interval) {
        return interval.toDuration().getStandardDays() > 1500L;
    }

    public List<Interval> getActiveRanges(Interval checkRange) {
        DateTime startDate = checkRange.getStart();
        DateTime endDate = checkRange.getEnd();
        return this.getActiveRanges(startDate, endDate);
    }

    public List<Interval> getActiveRanges(DateTime startDate, long duration) {
        if (duration > 0L) {
            return this.getFutureActiveRanges(startDate, duration);
        }
        if (duration < 0L) {
            return this.getPastActiveRanges(startDate, -duration);
        }
        return Collections.emptyList();
    }

    public boolean isActive(DateTime dateTime) {
        return this.isActiveImpl(dateTime);
    }

    private List<Interval> getPastActiveRanges(DateTime endDate, long duration) {
        endDate = new DateTime(endDate.getMillis(), this.dateTimeZone);
        LocalDate endDay = endDate.toLocalDate();
        LinkedList intervals = Lists.newLinkedList();
        LocalDate now = endDay;
        long remainingDuration = duration;
        for (int dayCount = 0; remainingDuration > 0L && dayCount < 1500; ++dayCount) {
            List<Interval> intervalsForDay = this.getIntervalsForDay(now, null, endDate);
            for (int x = intervalsForDay.size() - 1; x >= 0 && remainingDuration > 0L; --x) {
                Interval interval = intervalsForDay.get(x);
                long intervalDuration = interval.getEndMillis() - interval.getStartMillis();
                if (intervalDuration <= remainingDuration) {
                    this.prepend(intervals, interval);
                    remainingDuration -= intervalDuration;
                    continue;
                }
                this.prepend(intervals, new Interval(interval.getEndMillis() - remainingDuration, interval.getEndMillis(), this.dateTimeZone));
                remainingDuration = 0L;
            }
            now = now.minusDays(1);
        }
        return intervals;
    }

    private List<Interval> getFutureActiveRanges(DateTime startDate, long duration) {
        startDate = new DateTime(startDate.getMillis(), this.dateTimeZone);
        LocalDate startDay = startDate.toLocalDate();
        LinkedList intervals = Lists.newLinkedList();
        LocalDate now = startDay;
        long remainingDuration = duration;
        for (int dayCount = 0; remainingDuration > 0L && dayCount < 1500; ++dayCount) {
            List<Interval> intervalsForDay = this.getIntervalsForDay(now, startDate, null);
            Iterator<Interval> it = intervalsForDay.iterator();
            while (it.hasNext() && remainingDuration > 0L) {
                Interval interval = it.next();
                long intervalDuration = interval.getEndMillis() - interval.getStartMillis();
                if (intervalDuration <= remainingDuration) {
                    this.append((LinkedList<Interval>)intervals, interval);
                    remainingDuration -= intervalDuration;
                    continue;
                }
                this.append((LinkedList<Interval>)intervals, new Interval(interval.getStartMillis(), interval.getStartMillis() + remainingDuration, this.dateTimeZone));
                remainingDuration = 0L;
            }
            now = now.plusDays(1);
        }
        return intervals;
    }

    private List<Interval> getActiveRanges(DateTime startDate, DateTime endDate) {
        startDate = new DateTime(startDate.getMillis(), this.dateTimeZone);
        endDate = new DateTime(endDate.getMillis(), this.dateTimeZone);
        LocalDate startDay = startDate.toLocalDate();
        LocalDate endDay = endDate.toLocalDate();
        LinkedList intervals = Lists.newLinkedList();
        LocalDate now = startDay;
        for (int dayCount = 0; now.compareTo((ReadablePartial)endDay) <= 0 && dayCount < 1500; ++dayCount) {
            List<Interval> intervalsForDay = this.getIntervalsForDay(now, startDate, endDate);
            this.append((LinkedList<Interval>)intervals, intervalsForDay);
            now = now.plusDays(1);
        }
        return intervals;
    }

    private void append(LinkedList<Interval> list, List<Interval> intervalsToAppend) {
        for (Interval interval : intervalsToAppend) {
            this.append(list, interval);
        }
    }

    private void append(LinkedList<Interval> list, Interval intervalToAppend) {
        if (list.isEmpty()) {
            list.add(intervalToAppend);
        } else {
            Interval lastExisting = list.getLast();
            if (lastExisting.getEndMillis() == intervalToAppend.getStartMillis()) {
                list.removeLast();
                list.add(new Interval((ReadableInstant)lastExisting.getStart(), (ReadableInstant)intervalToAppend.getEnd()));
            } else {
                list.add(intervalToAppend);
            }
        }
    }

    private void prepend(LinkedList<Interval> list, Interval intervalToPrepend) {
        if (list.isEmpty()) {
            list.addFirst(intervalToPrepend);
        } else {
            Interval firstExisting = list.getFirst();
            if (intervalToPrepend.getEndMillis() == firstExisting.getStartMillis()) {
                list.removeFirst();
                list.addFirst(new Interval((ReadableInstant)intervalToPrepend.getStart(), (ReadableInstant)firstExisting.getEnd()));
            } else {
                list.addFirst(intervalToPrepend);
            }
        }
    }

    List<Interval> getIntervalsForDay(LocalDate day, DateTime lowerBoundary, DateTime upperBoundary) {
        if (this.offDays.isOffDay(day)) {
            return Collections.emptyList();
        }
        DayTimeRanges ranges = this.rangesPerWeekday[day.getDayOfWeek()];
        if (ranges.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList intervals = Lists.newArrayList();
        for (DayTimeRange range : ranges.getRanges()) {
            Interval interval = this.getInterval(day, range, lowerBoundary, upperBoundary);
            if (interval == null) continue;
            intervals.add(interval);
        }
        return intervals;
    }

    private Interval getInterval(LocalDate day, DayTimeRange range, DateTime lowerBoundary, DateTime upperBoundary) {
        DateTime start = this.toDateTime(day, range.getStart());
        DateTime end = this.toDateTime(day, range.getEnd());
        if (upperBoundary != null && start.compareTo((ReadableInstant)upperBoundary) > 0 || lowerBoundary != null && end.compareTo((ReadableInstant)lowerBoundary) < 0) {
            return null;
        }
        if (lowerBoundary != null && start.compareTo((ReadableInstant)lowerBoundary) < 0) {
            start = lowerBoundary;
        }
        if (upperBoundary != null && end.compareTo((ReadableInstant)upperBoundary) > 0) {
            end = upperBoundary;
        }
        if (start.getMillis() == end.getMillis()) {
            return null;
        }
        return new Interval((ReadableInstant)start, (ReadableInstant)end);
    }

    private boolean isActiveImpl(DateTime dateTime) {
        DateTime withTimezone = new DateTime(dateTime.getMillis(), this.dateTimeZone);
        LocalDate day = withTimezone.toLocalDate();
        if (this.offDays.isOffDay(day)) {
            return false;
        }
        DayTimeRanges ranges = this.rangesPerWeekday[day.getDayOfWeek()];
        if (ranges.isEmpty()) {
            return false;
        }
        for (DayTimeRange range : ranges.getRanges()) {
            if (!this.isDateTimeInside(day, range, dateTime)) continue;
            return true;
        }
        return false;
    }

    private boolean isDateTimeInside(LocalDate day, DayTimeRange dayTimeRange, DateTime dateTime) {
        DateTime start = this.toDateTime(day, dayTimeRange.getStart());
        DateTime end = this.toDateTime(day, dayTimeRange.getEnd());
        return start.getMillis() <= dateTime.getMillis() && dateTime.getMillis() < end.getMillis();
    }

    private DateTime toDateTime(LocalDate day, DayTime dayTime) {
        if (dayTime.getHours() >= 24) {
            LocalDate nextDay = day.plusDays(1);
            return new DateTime(nextDay.getYear(), nextDay.getMonthOfYear(), nextDay.getDayOfMonth(), 0, 0, this.dateTimeZone);
        }
        return new DateTime(day.getYear(), day.getMonthOfYear(), day.getDayOfMonth(), dayTime.getHours(), dayTime.getMinutes(), dayTime.getSeconds(), dayTime.getMilliseconds(), this.dateTimeZone);
    }
}

