/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.api.calendar;

import com.atlassian.jira.plugins.workinghours.api.calendar.Holiday;
import com.atlassian.jira.plugins.workinghours.internal.calendar.HolidayImpl;
import org.joda.time.LocalDate;

public class HolidayBuilder {
    private String name;
    private LocalDate date;
    private boolean recurring;

    public static HolidayBuilder builder() {
        return new HolidayBuilder();
    }

    public static HolidayBuilder builder(Holiday holiday) {
        return new HolidayBuilder(holiday);
    }

    private HolidayBuilder() {
    }

    private HolidayBuilder(Holiday holiday) {
        if (holiday != null) {
            this.name(holiday.getName());
            this.date(holiday.getDate());
            this.recurring(holiday.isRecurring());
        }
    }

    public HolidayBuilder name(String name) {
        this.name = name;
        return this;
    }

    public HolidayBuilder date(LocalDate date) {
        this.date = date;
        return this;
    }

    public HolidayBuilder recurring(boolean recurring) {
        this.recurring = recurring;
        return this;
    }

    public Holiday build() {
        return new HolidayImpl(0, this.name, this.date, this.recurring);
    }
}

