/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.api.calendar;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.jira.plugins.workinghours.api.calendar.Calendar;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarInfo;
import com.atlassian.jira.plugins.workinghours.api.calendar.Holiday;
import com.atlassian.jira.plugins.workinghours.api.calendar.WorkingTime;
import com.atlassian.jira.plugins.workinghours.internal.calendar.CalendarImpl;
import com.atlassian.jira.plugins.workinghours.internal.calendar.CalendarInfoImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTimeZone;

public class CalendarBuilder {
    private Integer id;
    private String name;
    private DateTimeZone timezone;
    private List<Holiday> holidays = Lists.newArrayList();
    private List<WorkingTime> workingTimes = Lists.newArrayList();
    @TenantAware(value=TenancyScope.TENANTED)
    private Map<String, String> context = Maps.newHashMap();

    public static CalendarBuilder builder() {
        return new CalendarBuilder();
    }

    public static CalendarBuilder builder(CalendarInfo calendarInfo) {
        return new CalendarBuilder(calendarInfo);
    }

    public static CalendarBuilder builder(Calendar calendar) {
        return new CalendarBuilder(calendar);
    }

    private CalendarBuilder() {
    }

    private CalendarBuilder(CalendarInfo calendarInfo) {
        this.id(calendarInfo.getId());
        this.name(calendarInfo.getName());
        this.timezone(calendarInfo.getTimeZone());
        this.context(calendarInfo.getContext());
    }

    private CalendarBuilder(Calendar calendar) {
        this((CalendarInfo)calendar);
        this.holidays(calendar.getHolidays());
        this.workingTimes(calendar.getWorkingTimes());
    }

    public CalendarBuilder id(Integer id) {
        this.id = id;
        return this;
    }

    public CalendarBuilder name(String name) {
        this.name = name;
        return this;
    }

    public CalendarBuilder timezone(DateTimeZone timezone) {
        this.timezone = timezone;
        return this;
    }

    public CalendarBuilder addHoliday(Holiday holiday) {
        this.holidays.add(holiday);
        return this;
    }

    public CalendarBuilder holidays(List<Holiday> holidays) {
        this.holidays.clear();
        if (holidays != null) {
            this.holidays.addAll(holidays);
        }
        return this;
    }

    public CalendarBuilder context(Map<String, String> context) {
        this.context.clear();
        if (context != null) {
            this.context.putAll(context);
        }
        return this;
    }

    public CalendarBuilder addWorkingTime(WorkingTime workingTime) {
        this.workingTimes.add(workingTime);
        return this;
    }

    public CalendarBuilder workingTimes(List<WorkingTime> workingTimes) {
        this.workingTimes.clear();
        if (workingTimes != null) {
            this.workingTimes.addAll(workingTimes);
        }
        return this;
    }

    public Calendar build() {
        return new CalendarImpl(this.id, this.name, this.timezone, this.context, this.holidays, this.workingTimes);
    }

    public CalendarInfo buildInfo() {
        return new CalendarInfoImpl(this.id, this.name, this.timezone, this.context);
    }
}

