/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.util.uri.context;

import com.atlassian.plugins.rest.common.interceptor.MethodInvocation;
import com.atlassian.plugins.rest.common.interceptor.ResourceInterceptor;
import com.atlassian.servicedesk.api.customer.NoExceptionsCallable;
import com.atlassian.servicedesk.api.rest.util.uri.context.CustomerContextRunner;
import com.atlassian.servicedesk.api.rest.util.uri.context.RequestScope;
import io.atlassian.fugue.Unit;
import java.lang.reflect.InvocationTargetException;

public class RequestScopeInterceptor
implements ResourceInterceptor {
    private final RequestScope scope;
    private final CustomerContextRunner customerContextRunner;

    public RequestScopeInterceptor(RequestScope scope, CustomerContextRunner customerContextRunner) {
        this.scope = scope;
        this.customerContextRunner = customerContextRunner;
    }

    public void intercept(MethodInvocation invocation) throws IllegalAccessException, InvocationTargetException {
        ExceptionCapture exceptionCapture = this.customerContextRunner.intercept(invocation, this.enterRequestScopeInvocation(invocation));
        exceptionCapture.rethrowIfCaptured();
    }

    private NoExceptionsCallable<ExceptionCapture> enterRequestScopeInvocation(MethodInvocation invocation) {
        return () -> {
            try {
                this.enterRequestScope(invocation);
                return ExceptionCapture.EMPTY;
            }
            catch (IllegalAccessException e) {
                return new ExceptionCapture(e);
            }
            catch (InvocationTargetException e) {
                return new ExceptionCapture(e);
            }
        };
    }

    private Unit enterRequestScope(MethodInvocation invocation) throws IllegalAccessException, InvocationTargetException {
        RequestScope.Request request = this.scope.beginRequest(invocation);
        try {
            invocation.invoke();
        }
        finally {
            request.destroy();
        }
        return Unit.VALUE;
    }

    private static class ExceptionCapture {
        public static final ExceptionCapture EMPTY = new ExceptionCapture();
        private final Exception exception;

        ExceptionCapture() {
            this.exception = null;
        }

        ExceptionCapture(IllegalAccessException exception) {
            this.exception = exception;
        }

        ExceptionCapture(InvocationTargetException exception) {
            this.exception = exception;
        }

        void rethrowIfCaptured() throws IllegalAccessException, InvocationTargetException {
            if (this.exception == null) {
                return;
            }
            if (this.exception instanceof IllegalAccessException) {
                throw (IllegalAccessException)this.exception;
            }
            if (this.exception instanceof InvocationTargetException) {
                throw (InvocationTargetException)this.exception;
            }
        }
    }
}

