/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.util.uri.context;

import com.atlassian.plugins.rest.common.interceptor.MethodInvocation;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.customer.NoExceptionsCallable;
import com.atlassian.servicedesk.api.rest.annotations.RunInCustomerContext;
import com.atlassian.servicedesk.api.rest.annotations.RunOutOfCustomerContext;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceMethod;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class CustomerContextRunner {
    private final CustomerContextService customerContextService;

    @Autowired
    CustomerContextRunner(CustomerContextService customerContextService) {
        this.customerContextService = customerContextService;
    }

    public <T> T intercept(MethodInvocation invocation, NoExceptionsCallable<T> callable) {
        AbstractResourceMethod resourceMethod = invocation.getMethod();
        AbstractResource resource = resourceMethod.getDeclaringResource();
        boolean inCustomerContext = true;
        if (resource.isAnnotationPresent(RunInCustomerContext.class)) {
            inCustomerContext = true;
        } else if (resource.isAnnotationPresent(RunOutOfCustomerContext.class)) {
            inCustomerContext = false;
        }
        if (resourceMethod.isAnnotationPresent(RunInCustomerContext.class)) {
            inCustomerContext = true;
        } else if (resourceMethod.isAnnotationPresent(RunOutOfCustomerContext.class)) {
            inCustomerContext = false;
        }
        if (inCustomerContext) {
            return (T)this.customerContextService.runInCustomerContext(callable);
        }
        return (T)this.customerContextService.runOutOfCustomerContext(callable);
    }
}

