/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.util.uri;

import com.atlassian.servicedesk.api.rest.util.uri.UriKit;
import java.net.URI;
import java.util.function.Function;

public class KnownUriPaths {
    public static final String SELF_PATH = "request/{requestId}";
    public static final String JIRA_REST_BASE_V2 = "rest/api/2";
    public static final String JIRA_BASE_URL = "http://host:port/context";
    public static final String JIRA_REST_ISSUE = "rest/api/2/issue/{requestId}";
    public static final String JIRA_REST_ISSUE_TYPE = "issuetype/{issueTypeId}";
    public static final String PORTAL_SD_PATH = "servicedesk/customer/portal/{serviceDeskId}";
    public static final String PORTAL_REQUEST_PATH = "servicedesk/customer/portal/{serviceDeskId}/{issueKey}";
    public static final String GET_QUEUES_PAGE_PATH = "servicedesk/{serviceDeskId}/queue";
    public static final String GET_QUEUE_PATH = "servicedesk/{serviceDeskId}/queue/{queueId}";
    public static final String REQUEST_TYPE = "requestType";
    public static final String SERVICE_DESK = "serviceDesk";
    public static final String CUSTOMER_REQUEST = "customerRequest";
    public static final String PARTICIPANT = "participant";
    public static final String REQUEST_STATUS = "status";
    public static final String REQUEST_SLA = "sla";
    public static final String ORGANIZATION_PATH = "organization";
    public static final String GET_ORGANIZATION_PATH = "organization/{organizationId}";
    public static final String GET_ORGANIZATION_IN_SERVICEDESK_PATH = "servicedesk/{serviceDeskId}/organization";
    public static final String APPROVAL_PATH = "request/{requestId}/approval";
    public static final String GET_SPECIFIC_APPROVAL_PATH = "request/{requestId}/approval/{approvalId}";

    public static Function<UriKit, URI> participantsLink(String issueIdOrKey) {
        return KnownUriPaths.selfLink("request/{issueIdOrKey}/participant", issueIdOrKey);
    }

    public static Function<UriKit, URI> slaLink(String issueIdOrKey) {
        return KnownUriPaths.selfLink("request/{issueIdOrKey}/sla", issueIdOrKey);
    }

    public static Function<UriKit, URI> statusLink(String issueIdOrKey) {
        return KnownUriPaths.selfLink("request/{issueIdOrKey}/status", issueIdOrKey);
    }

    private static Function<UriKit, URI> selfLink(String path, String issueIdOrKey) {
        return uriKit -> uriKit.getBaseUriBuilder().path(path).build(new Object[]{issueIdOrKey});
    }

    private KnownUriPaths() {
    }
}

