/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.util.experimental;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.plugins.rest.common.interceptor.MethodInvocation;
import com.atlassian.plugins.rest.common.interceptor.ResourceInterceptor;
import com.atlassian.servicedesk.api.rest.annotations.PublicRestApi;
import com.atlassian.servicedesk.api.rest.util.http.CacheControl;
import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.api.model.AbstractResourceMethod;
import io.atlassian.fugue.Option;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ExperimentalOptInInterceptor
implements ResourceInterceptor {
    public static final String EXPERIMENTAL_API_HEADER = "X-ExperimentalApi";
    private static final String EXPERIMENTAL_API_HEADER_EXAMPLE = "X-ExperimentalApi: opt-in";

    public void intercept(MethodInvocation invocation) throws IllegalAccessException, InvocationTargetException {
        HttpContext httpContext = invocation.getHttpContext();
        AbstractResourceMethod method = invocation.getMethod();
        if (this.isExperimental(method) && !ExperimentalOptInInterceptor.hasExperimentalHeader(httpContext.getRequest())) {
            httpContext.getResponse().setResponse(ExperimentalOptInInterceptor.createExperimentalHeaderRequiredResponse());
            return;
        }
        invocation.invoke();
    }

    @VisibleForTesting
    static Response createExperimentalHeaderRequiredResponse() {
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).type(MediaType.TEXT_PLAIN_TYPE).cacheControl(CacheControl.never()).entity((Object)String.format("This API is experimental.  Experimental APIs are not guaranteed to be stable within the preview period. You must set the header '%s' to opt into using this API.", EXPERIMENTAL_API_HEADER_EXAMPLE)).build();
    }

    @VisibleForTesting
    static boolean hasExperimentalHeader(HttpRequestContext request) {
        return Option.option((Object)request.getHeaderValue(EXPERIMENTAL_API_HEADER)).isDefined();
    }

    private boolean isExperimental(AbstractResourceMethod method) {
        return ExperimentalOptInInterceptor.isExperimental(method.getAnnotations());
    }

    @VisibleForTesting
    static boolean isExperimental(Annotation[] annotations) {
        if (annotations == null) {
            return true;
        }
        for (Annotation annotation : annotations) {
            if (annotation.annotationType().equals(ExperimentalApi.class)) {
                return true;
            }
            if (!annotation.annotationType().equals(PublicRestApi.class)) continue;
            return false;
        }
        return true;
    }
}

