/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.util.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;

@EventName(value="servicedesk.public.rest.api.call")
public class PublicRestApiAnalyticEvent
extends AnalyticsEvent {
    private final String resourceName;
    private final String resourceMethodName;
    private final String httpMethodName;
    private final Integer httpResponseCode;
    private final String path;
    private final boolean connectAddon;
    private final String connectAddonKey;
    private final String userAgent;

    private PublicRestApiAnalyticEvent(String resourceName, String resourceMethodName, String httpMethodName, Integer httpResponseCode, String path, boolean connectAddon, String connectAddonKey, String userAgent) {
        this.resourceName = resourceName;
        this.resourceMethodName = resourceMethodName;
        this.httpMethodName = httpMethodName;
        this.httpResponseCode = httpResponseCode;
        this.path = path;
        this.connectAddon = connectAddon;
        this.connectAddonKey = connectAddonKey;
        this.userAgent = userAgent;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceMethodName() {
        return this.resourceMethodName;
    }

    public String getHttpMethodName() {
        return this.httpMethodName;
    }

    public Integer getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isConnectAddon() {
        return this.connectAddon;
    }

    public String getConnectAddonKey() {
        return this.connectAddonKey;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String resourceName;
        private String resourceMethodName;
        private String httpMethodName;
        private String path;
        private boolean connectAddon;
        private String connectAddonKey;
        private String userAgent;
        private Integer httpResponseCode;

        public Builder setResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public Builder setResourceMethodName(String resourceMethodName) {
            this.resourceMethodName = resourceMethodName;
            return this;
        }

        public Builder setHttpMethodName(String httpMethodName) {
            this.httpMethodName = httpMethodName;
            return this;
        }

        public Builder setHttpResponseCode(Integer httpResponseCode) {
            this.httpResponseCode = httpResponseCode;
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setConnectAddon(boolean connectAddon) {
            this.connectAddon = connectAddon;
            return this;
        }

        public Builder setConnectAddonKey(String connectAddonKey) {
            this.connectAddonKey = connectAddonKey;
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public PublicRestApiAnalyticEvent build() {
            return new PublicRestApiAnalyticEvent(this.resourceName, this.resourceMethodName, this.httpMethodName, this.httpResponseCode, this.path, this.connectAddon, this.connectAddonKey, this.userAgent);
        }
    }
}

