/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.util;

import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.rest.dto.DTOFactory;
import com.atlassian.servicedesk.api.rest.dto.links.Linkable;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTOFactory;
import com.atlassian.servicedesk.api.rest.util.ErrorResponse;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import io.atlassian.fugue.Either;
import java.net.URI;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResponseFactory {
    private final PagedDTOFactory pagedDTOFactory;
    public static final javax.ws.rs.core.CacheControl NO_CACHE = new javax.ws.rs.core.CacheControl();

    @Autowired
    public ResponseFactory(PagedDTOFactory pagedDTOFactory) {
        this.pagedDTOFactory = pagedDTOFactory;
    }

    private Function<AnError, Response> errorAsResponse() {
        return anError -> {
            ErrorResponse errorResponse = ErrorResponse.from(anError);
            return Response.status((int)anError.getHttpStatusCode()).entity((Object)errorResponse).cacheControl(NO_CACHE).build();
        };
    }

    public static Response okNoCache(Object entity) {
        return Response.ok((Object)entity).cacheControl(NO_CACHE).build();
    }

    public static Response multiResponseNoCache(Object entity) {
        return Response.status((int)207).entity(entity).cacheControl(NO_CACHE).build();
    }

    public static Response noContent() {
        return Response.noContent().cacheControl(NO_CACHE).build();
    }

    public <S, T> Response entityResponse(S result, Function<S, T> mapper) {
        return ResponseFactory.okNoCache(mapper.apply(result));
    }

    public <S, T> Response entityResponse(S result, DTOFactory<S, T> dtoFactory) {
        return ResponseFactory.okNoCache(dtoFactory.toDTO(result));
    }

    public Response error(AnError error) {
        return this.errorAsResponse().apply(error);
    }

    public <S, T> Response entityResponse(Either<AnError, S> result, Function<S, T> mapper) {
        return (Response)result.map(mapper).map(this.dtoAsResponse()).right().on(this.errorAsResponse());
    }

    public <S, T> Response entityResponse(Either<AnError, S> result, DTOFactory<S, T> dtoFactory) {
        return (Response)result.map(this.factoryAsMapper(dtoFactory)).map(this.dtoAsResponse()).right().on(this.errorAsResponse());
    }

    public <S, T> Response pagedReponse(Either<AnError, PagedResponse<S>> result, Function<S, T> mapper) {
        return (Response)result.map(this.pagedDTOFactory.pageDtoMapper(mapper)).map(this.dtoAsResponse()).right().on(this.errorAsResponse());
    }

    public <S, T> Response pagedReponse(Either<AnError, PagedResponse<S>> result, DTOFactory<S, T> dtoFactory) {
        return (Response)result.map(this.pagedDTOFactory.pageDtoMapper(dtoFactory)).map(this.dtoAsResponse()).right().on(this.errorAsResponse());
    }

    public <S, T> Response createdResponseNoLink(Either<AnError, S> result, DTOFactory<S, T> dtoFactory) {
        return (Response)result.map(this.factoryAsMapper(dtoFactory)).map(entity -> Response.created(null).entity(entity).cacheControl(CacheControl.never()).build()).right().on(this.errorAsResponse());
    }

    public <S, T extends Linkable> Response createdResponse(Either<AnError, S> result, DTOFactory<S, T> dtoFactory) {
        return (Response)result.map(this.factoryAsMapper(dtoFactory)).map(this.createdDtoAsResponse()).right().on(this.errorAsResponse());
    }

    public <S, T extends Linkable> Response createdResponse(Either<AnError, S> result, Function<S, T> mapper) {
        return (Response)result.map(mapper).map(this.createdDtoAsResponse()).right().on(this.errorAsResponse());
    }

    private <S, T> Function<S, T> factoryAsMapper(DTOFactory<S, T> factory) {
        return s -> factory.toDTO(s);
    }

    private <T> Function<T, Response> dtoAsResponse() {
        return t -> ResponseFactory.okNoCache(t);
    }

    private <T extends Linkable> Function<T, Response> createdDtoAsResponse() {
        return entity -> Response.created((URI)entity.getSelf()).entity(entity).cacheControl(CacheControl.never()).build();
    }

    static {
        NO_CACHE.setNoStore(true);
        NO_CACHE.setNoCache(true);
    }
}

