/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.assembler.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import io.atlassian.fugue.Either;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueIdOrKeyConverter {
    private final IssueManager issueManager;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public IssueIdOrKeyConverter(IssueManager issueManager, ErrorResultHelper errorResultHelper) {
        this.issueManager = issueManager;
        this.errorResultHelper = errorResultHelper;
    }

    public Either<AnError, Long> toIssueId(String issueIdOrKey) {
        if (this.isIssueId(issueIdOrKey)) {
            return Either.right((Object)Long.valueOf(issueIdOrKey));
        }
        Optional<Long> issueOpt = Optional.ofNullable(this.issueManager.getIssueObject(issueIdOrKey)).map(Issue::getId);
        return issueOpt.map(Either::right).orElseGet(this.issueNotFound());
    }

    public Either<AnError, Issue> toIssue(String issueIdOrKey) {
        Issue issue = this.getIssueFromIdOrKey(issueIdOrKey);
        if (issue == null) {
            return Either.left((Object)this.issueNotFoundError());
        }
        return Either.right((Object)issue);
    }

    private Issue getIssueFromIdOrKey(String issueIdOrKey) {
        if (this.isIssueId(issueIdOrKey)) {
            return this.issueManager.getIssueObject(Long.valueOf(issueIdOrKey));
        }
        return this.issueManager.getIssueObject(issueIdOrKey);
    }

    private <T> Supplier<Either<AnError, T>> issueNotFound() {
        return () -> Either.left((Object)this.issueNotFoundError());
    }

    private AnError issueNotFoundError() {
        return this.errorResultHelper.notFound404("sd.portal.error.issue.not.found", new Object[0]).build();
    }

    private boolean isIssueId(String issueIdOrKey) {
        return StringUtils.isNumeric((String)issueIdOrKey);
    }
}

