/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.assembler;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.AttachmentError;
import com.atlassian.jira.issue.AttachmentValidator;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachmentManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.rest.dto.domain.attachment.CreateTemporaryWebAttachmentResultDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.attachment.TemporaryWebAttachmentDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.attachment.TemporaryWebAttachmentDTOFactory;
import com.atlassian.servicedesk.api.rest.resource.assembler.TemporaryFileAssembler;
import com.atlassian.servicedesk.api.util.fp.FpKit;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Eithers;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TemporaryFileAssemblerImpl
implements TemporaryFileAssembler {
    private final ServiceDeskService serviceDeskService;
    private final TemporaryWebAttachmentManager temporaryWebAttachmentManager;
    private final AttachmentValidator attachmentValidator;
    private final XsrfTokenGenerator xsrfGenerator;
    private final ProjectManager projectManager;
    private final ErrorResultHelper errorResultHelper;
    private final TemporaryWebAttachmentDTOFactory temporaryWebAttachmentDTOFactory;

    @Autowired
    public TemporaryFileAssemblerImpl(ServiceDeskService serviceDeskService, TemporaryWebAttachmentManager temporaryWebAttachmentManager, AttachmentValidator attachmentValidator, XsrfTokenGenerator xsrfGenerator, ProjectManager projectManager, ErrorResultHelper errorResultHelper, TemporaryWebAttachmentDTOFactory temporaryWebAttachmentDTOFactory) {
        this.serviceDeskService = serviceDeskService;
        this.temporaryWebAttachmentManager = temporaryWebAttachmentManager;
        this.attachmentValidator = attachmentValidator;
        this.xsrfGenerator = xsrfGenerator;
        this.projectManager = projectManager;
        this.errorResultHelper = errorResultHelper;
        this.temporaryWebAttachmentDTOFactory = temporaryWebAttachmentDTOFactory;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, CreateTemporaryWebAttachmentResultDTO> attachTemporaryFiles(ApplicationUser user, long serviceDeskId, Collection<FilePart> fileParts, HttpServletRequest request) {
        return Steps.begin(this.validateAttachmentTarget(user, serviceDeskId)).then(target -> this.canCreateTemporaryAttachment(user, (io.atlassian.fugue.Either<Issue, Project>)target)).then((target, permission) -> this.createTemporaryAttachments(user, (io.atlassian.fugue.Either<Issue, Project>)target, fileParts, this.getOrCreateFormToken(request))).yield((target, permission, result) -> result);
    }

    private io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<Issue, Project>> validateAttachmentTarget(ApplicationUser user, long serviceDeskId) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskById(user, serviceDeskId))).yield(sd -> io.atlassian.fugue.Either.right((Object)this.projectManager.getProjectObj(Long.valueOf(sd.getProjectId()))));
    }

    private String getOrCreateFormToken(HttpServletRequest request) {
        return this.xsrfGenerator.generateToken(request);
    }

    private io.atlassian.fugue.Either<AnError, CreateTemporaryWebAttachmentResultDTO> createTemporaryAttachments(ApplicationUser user, io.atlassian.fugue.Either<Issue, Project> attachmentTarget, Collection<FilePart> fileParts, String atl_token) {
        if (!Optional.ofNullable(fileParts).isPresent() || fileParts.size() == 0) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.badRequest400("sd.attachment.empty.error", new Object[0]).build());
        }
        List result = FpKit.map(fileParts, this.createTemporaryAttachment(user, attachmentTarget, atl_token));
        Iterator errors = Eithers.filterLeft((Iterable)result).iterator();
        if (errors.hasNext()) {
            return io.atlassian.fugue.Either.left(errors.next());
        }
        ArrayList attachments = Lists.newArrayList((Iterable)Eithers.filterRight((Iterable)result));
        return io.atlassian.fugue.Either.right((Object)new CreateTemporaryWebAttachmentResultDTO(attachments));
    }

    private io.atlassian.fugue.Either<AnError, Boolean> canCreateTemporaryAttachment(ApplicationUser user, io.atlassian.fugue.Either<Issue, Project> attachmentTarget) {
        if (!this.attachmentValidator.canCreateTemporaryAttachments(user, StepsConverters.olderEither(attachmentTarget), (ErrorCollection)new SimpleErrorCollection())) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.forbidden403("sd.attachment.permission.error", new Object[0]).build());
        }
        return io.atlassian.fugue.Either.right((Object)true);
    }

    private Function<FilePart, io.atlassian.fugue.Either<AnError, TemporaryWebAttachmentDTO>> createTemporaryAttachment(ApplicationUser user, io.atlassian.fugue.Either<Issue, Project> attachmentTarget, String atl_token) {
        return filePart -> Steps.begin(this.toTempFile((FilePart)filePart)).then(file -> this.createTemporaryAttachment(user, attachmentTarget, atl_token, (File)file, this.getFilename((FilePart)filePart), StringUtils.defaultString((String)filePart.getContentType(), (String)"application/octet-stream"))).yield((file, dto) -> dto);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private io.atlassian.fugue.Either<AnError, TemporaryWebAttachmentDTO> createTemporaryAttachment(ApplicationUser user, io.atlassian.fugue.Either<Issue, Project> attachmentTarget, String formToken, File tempFile, String fileName, String contentType) {
        try {
            long sizeInByte = tempFile.length();
            try (FileInputStream inputStream = new FileInputStream(tempFile);){
                io.atlassian.fugue.Either either = StepsConverters.newerEither((Either)this.temporaryWebAttachmentManager.createTemporaryWebAttachment((InputStream)inputStream, fileName, contentType, sizeInByte, StepsConverters.olderEither(attachmentTarget), formToken, user)).bimap(this.toAnError(), this.temporaryWebAttachmentDTOFactory.toDTO());
                return either;
            }
        }
        catch (IOException ioe) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.internalServiceError500("sd.attachment.create.error", new Object[]{ioe.getLocalizedMessage()}).build());
        }
    }

    private java.util.function.Function<AttachmentError, AnError> toAnError() {
        return attachmentError -> this.errorResultHelper.anError(attachmentError.getReason().getHttpStatusCode(), "sd.attachment.create.error", new Object[]{attachmentError.getLocalizedMessage()});
    }

    private String getFilename(FilePart filePart) {
        String[] parts = filePart.getName().split(Pattern.quote(File.separator));
        return parts[parts.length - 1];
    }

    private io.atlassian.fugue.Either<AnError, File> toTempFile(FilePart filePart) {
        try {
            File file = File.createTempFile("jsd-attachment-", ".tmp");
            file.deleteOnExit();
            filePart.write(file);
            return io.atlassian.fugue.Either.right((Object)file);
        }
        catch (IOException ioe) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.badRequest400("sd.attachment.create.error", new Object[]{ioe.getLocalizedMessage()}).build());
        }
    }
}

