/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.assembler;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.comment.ServiceDeskComment;
import com.atlassian.servicedesk.api.comment.ServiceDeskCommentCreateParameters;
import com.atlassian.servicedesk.api.comment.ServiceDeskCommentQuery;
import com.atlassian.servicedesk.api.comment.ServiceDeskCommentService;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.request.CustomerRequestQuery;
import com.atlassian.servicedesk.api.request.ServiceDeskCustomerRequestService;
import com.atlassian.servicedesk.api.rest.dto.domain.comment.CommentCreateDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.RestPagedRequest;
import com.atlassian.servicedesk.api.rest.resource.assembler.ServiceDeskCommentParameterAssembler;
import com.atlassian.servicedesk.api.rest.resource.assembler.util.IssueIdOrKeyConverter;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import io.atlassian.fugue.Eithers;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskCommentParameterAssemblerImpl
implements ServiceDeskCommentParameterAssembler {
    private final ServiceDeskCustomerRequestService serviceDeskCustomerRequestService;
    private final ServiceDeskCommentService serviceDeskCommentService;
    private final ErrorResultHelper errorHelper;
    private final IssueIdOrKeyConverter idOrKeyConverter;

    @Autowired
    public ServiceDeskCommentParameterAssemblerImpl(ServiceDeskCustomerRequestService serviceDeskCustomerRequestService, ServiceDeskCommentService serviceDeskCommentService, ErrorResultHelper errorHelper, IssueIdOrKeyConverter idOrKeyConverter) {
        this.serviceDeskCustomerRequestService = serviceDeskCustomerRequestService;
        this.serviceDeskCommentService = serviceDeskCommentService;
        this.errorHelper = errorHelper;
        this.idOrKeyConverter = idOrKeyConverter;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, ServiceDeskCommentCreateParameters> createCommentParameters(ApplicationUser user, String issueIdOrKey, CommentCreateDTO createDTO) {
        return Steps.begin(this.validateCreateCommentParameter(createDTO)).then(() -> this.idOrKeyConverter.toIssueId(issueIdOrKey)).then((validationResult, issueId) -> this.getCustomerRequest(user, (Long)issueId)).yield((validationResult, issueId, customerRequest) -> this.serviceDeskCommentService.newCreateBuilder().author(user).body(createDTO.getBody()).publicComment(createDTO.get_public().booleanValue()).issue(customerRequest.getIssue()).build());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, PagedResponse<ServiceDeskComment>> queryComments(ApplicationUser user, String issueIdOrKey, Boolean publicComment, Boolean internalComment, Integer start, Integer limit) {
        return Steps.begin(this.idOrKeyConverter.toIssueId(issueIdOrKey)).then(issueId -> this.getCustomerRequest(user, (Long)issueId)).then((issueId, customerRequest) -> StepsConverters.newerEither((Either)this.serviceDeskCommentService.getCommentsOfRequest(user, this.buildCommentQuery(customerRequest.getIssue(), publicComment, internalComment, start, limit)))).yield((issueId, customerRequest, serviceDeskComments) -> serviceDeskComments);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, ServiceDeskComment> getCommentById(ApplicationUser user, String issueIdOrKey, Long commentId) {
        return Steps.begin(this.idOrKeyConverter.toIssueId(issueIdOrKey)).then(issueId -> this.getCustomerRequest(user, (Long)issueId)).then(() -> StepsConverters.newerEither((Either)this.serviceDeskCommentService.getServiceDeskCommentById(user, commentId))).yield((issueId, customerRequest, comment) -> comment);
    }

    private io.atlassian.fugue.Either<AnError, CommentCreateDTO> validateCreateCommentParameter(CommentCreateDTO commentCreateDTO) {
        if (commentCreateDTO.get_public() == null) {
            return io.atlassian.fugue.Either.left((Object)this.errorHelper.badRequest400("sd.comment.api.no.public.attribute", new Object[0]).build());
        }
        if (StringUtils.isBlank((String)commentCreateDTO.getBody())) {
            return io.atlassian.fugue.Either.left((Object)this.errorHelper.badRequest400("sd.comment.api.empty.body.and.attachment", new Object[0]).build());
        }
        return io.atlassian.fugue.Either.right((Object)commentCreateDTO);
    }

    private io.atlassian.fugue.Either<AnError, CustomerRequest> getCustomerRequest(ApplicationUser user, Long requestId) {
        CustomerRequestQuery query = this.serviceDeskCustomerRequestService.newQueryBuilder().issue(requestId).requestOverrideSecurity(Boolean.valueOf(true)).build();
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskCustomerRequestService.getCustomerRequests(user, query).map(PagedResponse::findFirst))).then(customerRequestOpt -> Eithers.cond((boolean)customerRequestOpt.isPresent(), (Object)this.requestNotFound(), customerRequestOpt.get())).yield((customerRequestOpt, customerRequest) -> customerRequest);
    }

    private ServiceDeskCommentQuery buildCommentQuery(Issue issue, Boolean publicComment, Boolean internalComment, Integer start, Integer limit) {
        return this.serviceDeskCommentService.newQueryBuilder().issue(issue).publicComment(publicComment).internalComment(internalComment).pagedRequest(RestPagedRequest.fromQueryParams(start, limit)).build();
    }

    private AnError requestNotFound() {
        return this.errorHelper.notFound404("sd.request.not.found", new Object[0]).build();
    }
}

