/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.assembler;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.portal.PortalService;
import com.atlassian.servicedesk.api.requesttype.RequestTypeGroup;
import com.atlassian.servicedesk.api.rest.resource.assembler.RequestTypeGroupAssembler;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequestImpl;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.api.util.paging.PagedResponseImpl;
import com.atlassian.servicedesk.internal.api.requesttype.group.RequestTypeGroupService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeGroupAssemblerImpl
implements RequestTypeGroupAssembler {
    private final ServiceDeskService serviceDeskService;
    private final PortalService portalService;
    private final ProjectManager projectManager;
    private final RequestTypeGroupService requestTypeGroupService;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public RequestTypeGroupAssemblerImpl(ServiceDeskService serviceDeskService, PortalService portalService, ProjectManager projectManager, RequestTypeGroupService requestTypeGroupService, ErrorResultHelper errorResultHelper) {
        this.serviceDeskService = serviceDeskService;
        this.portalService = portalService;
        this.projectManager = projectManager;
        this.requestTypeGroupService = requestTypeGroupService;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, PagedResponse<RequestTypeGroup>> getGroups(ApplicationUser user, Integer serviceDeskId, PagedRequest pagedRequest) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskById(user, (long)serviceDeskId.intValue()))).then(sd -> this.getProject(sd.getProjectId())).then((sd, proj) -> StepsConverters.newerEither((Either)this.portalService.getPortalForProject(user, proj))).then((sd, proj, portal) -> this.requestTypeGroupService.getGroups(user, proj, portal)).yield((sd, proj, portal, groups) -> PagedResponseImpl.toPagedResponse((LimitedPagedRequest)LimitedPagedRequestImpl.create((PagedRequest)pagedRequest, (int)50), (List)groups));
    }

    private io.atlassian.fugue.Either<AnError, Project> getProject(Long projectId) {
        Project project = this.projectManager.getProjectObj(projectId);
        if (project == null) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.notFound404("sd.admin.servicedesk.error.missingproject", new Object[0]).build());
        }
        return io.atlassian.fugue.Either.right((Object)project);
    }
}

