/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.assembler;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.config.IssueTypeService;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeCreateParameters;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.RequestTypeCreateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.RequestTypeDTOFactory;
import com.atlassian.servicedesk.api.rest.resource.assembler.RequestTypeAssembler;
import com.atlassian.servicedesk.api.rest.resource.assembler.util.InputValidator;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import io.atlassian.fugue.Suppliers;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeAssemblerImpl
implements RequestTypeAssembler {
    private final ServiceDeskService serviceDeskService;
    private final RequestTypeService requestTypeService;
    private final ErrorResultHelper errorResultHelper;
    private final ResponseFactory responseFactory;
    private final RequestTypeDTOFactory requestTypeDTOFactory;
    private final IssueTypeService issueTypeService;
    private final InputValidator inputValidator;

    @Autowired
    public RequestTypeAssemblerImpl(ServiceDeskService serviceDeskService, RequestTypeService requestTypeService, ErrorResultHelper errorResultHelper, ResponseFactory responseFactory, RequestTypeDTOFactory requestTypeDTOFactory, IssueTypeService issueTypeService, InputValidator inputValidator) {
        this.serviceDeskService = serviceDeskService;
        this.requestTypeService = requestTypeService;
        this.errorResultHelper = errorResultHelper;
        this.responseFactory = responseFactory;
        this.requestTypeDTOFactory = requestTypeDTOFactory;
        this.issueTypeService = issueTypeService;
        this.inputValidator = inputValidator;
    }

    @Override
    public Response createRequestType(ApplicationUser user, Integer serviceDeskId, RequestTypeCreateDTO requestTypeCreateDTO) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskById(user, (long)serviceDeskId.intValue()))).then(() -> this.inputValidator.validateInteger(requestTypeCreateDTO.getIssueTypeId())).then((sd, itId) -> this.getIssueTypeById(user, (int)itId)).then((sd, itId, it) -> this.doCreateNewRequestType(user, (ServiceDesk)sd, (IssueType)it, requestTypeCreateDTO)).yield((sd, itId, it, rt) -> rt);
        return this.responseFactory.createdResponse(result, this.requestTypeDTOFactory.dtoMapper(serviceDeskId));
    }

    private io.atlassian.fugue.Either<AnError, IssueType> getIssueTypeById(ApplicationUser user, int issueTypeId) {
        return StepsConverters.newerOption((Option)this.issueTypeService.getIssueType(user, String.valueOf(issueTypeId))).toRight(Suppliers.ofInstance((Object)this.issueTypeNotFound()));
    }

    private io.atlassian.fugue.Either<AnError, RequestType> doCreateNewRequestType(ApplicationUser user, ServiceDesk serviceDesk, IssueType issueType, RequestTypeCreateDTO requestTypeCreateDTO) {
        RequestTypeCreateParameters createParameters = this.requestTypeService.newCreateBuilder().serviceDesk(serviceDesk).issueType(issueType).name(requestTypeCreateDTO.getName()).description(requestTypeCreateDTO.getDescription()).helpText(requestTypeCreateDTO.getHelpText()).build();
        return StepsConverters.newerEither((Either)this.requestTypeService.createRequestType(user, createParameters));
    }

    private AnError issueTypeNotFound() {
        return this.errorResultHelper.notFound404("sd.api.issue.type.not.found", new Object[0]).build();
    }
}

