/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.assembler;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.rest.resource.assembler.RequestSlaAssembler;
import com.atlassian.servicedesk.api.rest.resource.assembler.util.IssueIdOrKeyConverter;
import com.atlassian.servicedesk.api.rest.resource.error.ErrorHelper;
import com.atlassian.servicedesk.api.sla.info.SlaInformation;
import com.atlassian.servicedesk.api.sla.info.SlaInformationQuery;
import com.atlassian.servicedesk.api.sla.info.SlaInformationService;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.api.util.paging.SimplePagedRequest;
import io.atlassian.fugue.Option;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestSlaAssemblerImpl
implements RequestSlaAssembler {
    private final IssueIdOrKeyConverter idOrKeyConverter;
    private final SlaInformationService slaInformationService;

    @Autowired
    public RequestSlaAssemblerImpl(IssueIdOrKeyConverter idOrKeyConverter, SlaInformationService slaInformationService) {
        this.idOrKeyConverter = idOrKeyConverter;
        this.slaInformationService = slaInformationService;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, PagedResponse<SlaInformation>> getSlaInfo(ApplicationUser user, String issueIdOrKey, PagedRequest pagedRequest) {
        return Steps.begin(this.createQueryParameters(issueIdOrKey, pagedRequest, (Option<Long>)Option.none())).then(query -> StepsConverters.newerEither((Either)this.slaInformationService.getInfo(user, query))).yield((query, info) -> info);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, SlaInformation> getSlaInfoById(ApplicationUser user, String issueIdOrKey, Option<Long> slaMetricId) {
        return Steps.begin(this.createQueryParameters(issueIdOrKey, SimplePagedRequest.ONE, slaMetricId)).then(query -> StepsConverters.newerEither((Either)this.slaInformationService.getInfo(user, query))).then((query, info) -> this.errorIfEmpty(info.findFirst())).yield((query, info, slaInformation) -> slaInformation);
    }

    private io.atlassian.fugue.Either<AnError, SlaInformation> errorIfEmpty(Optional<SlaInformation> first) {
        return Option.fromOptional(first).toRight(ErrorHelper::entityNotFound);
    }

    private io.atlassian.fugue.Either<AnError, SlaInformationQuery> createQueryParameters(String issueIdOrKey, PagedRequest pagedRequest, Option<Long> slaMetricId) {
        return Steps.begin(this.idOrKeyConverter.toIssueId(issueIdOrKey)).yield(issueId -> this.createQueryParameters(pagedRequest, slaMetricId, (Long)issueId));
    }

    private SlaInformationQuery createQueryParameters(PagedRequest pagedRequest, Option<Long> slaMetricId, Long issueId) {
        SlaInformationQuery.Builder builder = this.slaInformationService.newInfoQueryBuilder().issue(issueId).pagedRequest(pagedRequest);
        if (slaMetricId.isDefined()) {
            builder.id((Long)slaMetricId.get());
        }
        return builder.build();
    }
}

