/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.assembler;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.IssueBeanBuilder2;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.queue.Queue;
import com.atlassian.servicedesk.api.queue.QueueQuery;
import com.atlassian.servicedesk.api.queue.QueueRequestQuery;
import com.atlassian.servicedesk.api.queue.QueueService;
import com.atlassian.servicedesk.api.rest.dto.DTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.queue.QueueDTO;
import com.atlassian.servicedesk.api.rest.resource.assembler.QueueAssembler;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import com.atlassian.servicedesk.api.rest.util.uri.UriKit;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.List;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueueAssemblerImpl
implements QueueAssembler {
    private final QueueService queueService;
    private final BeanBuilderFactory beanBuilderFactory;
    private final UriKit uriKit;
    private final DTOFactory<Queue, QueueDTO> queueDtoFactory;
    private final ResponseFactory responseFactory;
    private final ErrorResultHelper errorResultHelper;
    private static final Function<IssueBean, IssueBean> YAY_I_DO_NOTHING = issue -> issue;

    @Autowired
    public QueueAssemblerImpl(QueueService queueService, BeanBuilderFactory beanBuilderFactory, UriKit uriKit, DTOFactory<Queue, QueueDTO> queueDtoFactory, ResponseFactory responseFactory, ErrorResultHelper errorResultHelper) {
        this.queueService = queueService;
        this.beanBuilderFactory = beanBuilderFactory;
        this.uriKit = uriKit;
        this.queueDtoFactory = queueDtoFactory;
        this.responseFactory = responseFactory;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public Response getQueues(ApplicationUser user, Long serviceDeskId, boolean includeCount, PagedRequest pagedRequest) {
        QueueQuery query = this.queueService.newQueueQueryBuilder().serviceDeskId(serviceDeskId.longValue()).includeIssueCount(includeCount).pagedRequest(pagedRequest).build();
        return this.responseFactory.pagedReponse(StepsConverters.newerEither((Either)this.queueService.getQueues(user, query)), this.queueDtoFactory);
    }

    @Override
    public Response getIssuesInQueue(ApplicationUser user, Long serviceDeskId, Long queueId, PagedRequest pagedRequest) {
        QueueRequestQuery query = this.queueService.newQueueRequestQueryBuilder().serviceDeskId(serviceDeskId.longValue()).queueId(queueId.longValue()).pagedRequest(pagedRequest).build();
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.queueService.getRequestsByQueue(user, query))).then(() -> this.getQueueById(user, queueId, serviceDeskId)).yield((issues, queue) -> this.toIssueBean((PagedResponse<Issue>)issues, queue.getFields()));
        return this.responseFactory.pagedReponse(result, YAY_I_DO_NOTHING);
    }

    private io.atlassian.fugue.Either<AnError, Queue> getQueueById(ApplicationUser user, long queueId, long serviceDeskId) {
        QueueQuery query = this.queueService.newQueueQueryBuilder().serviceDeskId(serviceDeskId).queueId(queueId).build();
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.queueService.getQueues(user, query))).then(this::getFirstItem).yield((queues, queue) -> queue);
    }

    private io.atlassian.fugue.Either<AnError, Queue> getFirstItem(PagedResponse<Queue> queues) {
        if (queues.findFirst().isPresent()) {
            return io.atlassian.fugue.Either.right(queues.findFirst().get());
        }
        return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.notFound404("sd.admin.queue.general.error.notfound", new Object[0]).build());
    }

    private PagedResponse<IssueBean> toIssueBean(PagedResponse<Issue> issues, List<String> fields) {
        IssueBeanBuilder2 beanBuilder = this.beanBuilderFactory.newIssueBeanBuilder2(IncludedFields.includeAllByDefault((List)Lists.newArrayList((Object[])new StringList[]{StringList.fromList(fields)})), "", UriBuilder.fromUri((URI)this.uriKit.getJIRABaseURI()).path("rest/api/2"));
        return issues.map(arg_0 -> ((IssueBeanBuilder2)beanBuilder).build(arg_0));
    }
}

