/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.assembler;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.organization.OrganizationService;
import com.atlassian.servicedesk.api.organization.OrganizationServiceDeskUpdateParameters;
import com.atlassian.servicedesk.api.organization.OrganizationsQuery;
import com.atlassian.servicedesk.api.rest.dto.domain.servicedesk.organization.OrganizationServiceDeskUpdateDTO;
import com.atlassian.servicedesk.api.rest.resource.assembler.OrganizationServiceDeskAssembler;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import io.atlassian.fugue.Unit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrganizationServiceDeskAssemblerImpl
implements OrganizationServiceDeskAssembler {
    private final OrganizationService organizationService;

    @Autowired
    public OrganizationServiceDeskAssemblerImpl(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, PagedResponse<CustomerOrganization>> getOrganizationsInServiceDesk(ApplicationUser user, Integer serviceDeskId, PagedRequest pagedRequest) {
        OrganizationsQuery query = this.organizationService.newOrganizationsQueryBuilder().pagedRequest(pagedRequest).serviceDeskId(serviceDeskId).build();
        return StepsConverters.newerEither((Either)this.organizationService.getOrganizations(user, query));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Unit> addOrganizationToServiceDesk(ApplicationUser user, Integer serviceDeskId, OrganizationServiceDeskUpdateDTO organizationServiceDeskUpdateDTO) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.organizationService.getById(user, organizationServiceDeskUpdateDTO.getOrganizationId()).map(organization -> this.buildOrganizationServiceDeskUpdateParams(serviceDeskId, (CustomerOrganization)organization)))).then(params -> StepsConverters.newerEither((Either)this.organizationService.addOrganizationToServiceDesk(user, params))).yield((params, unit) -> Unit.Unit());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Unit> removeOrganizationFromServiceDesk(ApplicationUser user, Integer serviceDeskId, OrganizationServiceDeskUpdateDTO organizationServiceDeskUpdateDTO) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.organizationService.getById(user, organizationServiceDeskUpdateDTO.getOrganizationId()).map(organization -> this.buildOrganizationServiceDeskUpdateParams(serviceDeskId, (CustomerOrganization)organization)))).then(params -> StepsConverters.newerEither((Either)this.organizationService.removeOrganizationFromServiceDesk(user, params))).yield((params, unit) -> Unit.Unit());
    }

    private OrganizationServiceDeskUpdateParameters buildOrganizationServiceDeskUpdateParams(Integer serviceDeskId, CustomerOrganization organization) {
        return this.organizationService.newOrganizationServiceDeskUpdateParametersBuilder().serviceDeskId(serviceDeskId).organization(organization).build();
    }
}

