/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.assembler;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.organization.CreateOrganizationParameters;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.organization.OrganizationService;
import com.atlassian.servicedesk.api.organization.OrganizationsQuery;
import com.atlassian.servicedesk.api.rest.dto.domain.organization.OrganizationCreateDTO;
import com.atlassian.servicedesk.api.rest.resource.assembler.OrganizationAssembler;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import io.atlassian.fugue.Unit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrganizationAssemblerImpl
implements OrganizationAssembler {
    private final OrganizationService organizationService;

    @Autowired
    public OrganizationAssemblerImpl(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, CustomerOrganization> getOrganization(ApplicationUser applicationUser, Integer organizationId) {
        return StepsConverters.newerEither((Either)this.organizationService.getById(applicationUser, organizationId));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, CustomerOrganization> createOrganization(ApplicationUser applicationUser, OrganizationCreateDTO organizationCreateDTO) {
        CreateOrganizationParameters parameters = this.organizationService.newCreateBuilder().name(organizationCreateDTO.getName()).build();
        return StepsConverters.newerEither((Either)this.organizationService.createOrganization(applicationUser, parameters));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Unit> deleteOrganization(ApplicationUser applicationUser, Integer organizationId) {
        return StepsConverters.newerEither((Either)this.organizationService.delete(applicationUser, organizationId)).map(unit -> Unit.Unit());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, PagedResponse<CustomerOrganization>> getOrganizations(ApplicationUser user, PagedRequest pagedRequest) {
        OrganizationsQuery requestQuery = this.organizationService.newOrganizationsQueryBuilder().pagedRequest(pagedRequest).build();
        return StepsConverters.newerEither((Either)this.organizationService.getOrganizations(user, requestQuery));
    }
}

