/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.assembler;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.comment.ServiceDeskComment;
import com.atlassian.servicedesk.api.comment.ServiceDeskCommentCreateParameters;
import com.atlassian.servicedesk.api.comment.ServiceDeskCommentService;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.request.CustomerRequestQuery;
import com.atlassian.servicedesk.api.request.ServiceDeskCustomerRequestService;
import com.atlassian.servicedesk.api.rest.dto.domain.attachment.AttachmentCreateDTO;
import com.atlassian.servicedesk.api.rest.resource.assembler.AttachmentAssembler;
import com.atlassian.servicedesk.api.rest.resource.assembler.util.IssueIdOrKeyConverter;
import com.atlassian.servicedesk.api.util.fp.FpKit;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import io.atlassian.fugue.Eithers;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachmentAssemblerImpl
implements AttachmentAssembler {
    private final ServiceDeskCommentService serviceDeskCommentService;
    private final ServiceDeskCustomerRequestService serviceDeskCustomerRequestService;
    private final IssueIdOrKeyConverter issueIdOrKeyConverter;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public AttachmentAssemblerImpl(ServiceDeskCommentService serviceDeskCommentService, ServiceDeskCustomerRequestService serviceDeskCustomerRequestService, IssueIdOrKeyConverter issueIdOrKeyConverter, ErrorResultHelper errorResultHelper) {
        this.serviceDeskCommentService = serviceDeskCommentService;
        this.serviceDeskCustomerRequestService = serviceDeskCustomerRequestService;
        this.issueIdOrKeyConverter = issueIdOrKeyConverter;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, ServiceDeskComment> attach(ApplicationUser user, String issueIdOrKey, AttachmentCreateDTO attachmentCreateDTO) {
        return Steps.begin(this.getCustomerRequest(user, issueIdOrKey)).then(cr -> StepsConverters.newerEither((Either)this.serviceDeskCommentService.createServiceDeskComment(user, this.createCommentCreateParams(user, (CustomerRequest)cr, attachmentCreateDTO)))).yield((cr, comment) -> comment);
    }

    private ServiceDeskCommentCreateParameters createCommentCreateParams(ApplicationUser user, CustomerRequest customerRequest, AttachmentCreateDTO attachmentCreateDTO) {
        String commentBody = "";
        if (attachmentCreateDTO.getAdditionalComment() != null) {
            commentBody = attachmentCreateDTO.getAdditionalComment().getBody();
        }
        return this.serviceDeskCommentService.newCreateBuilder().author(user).issue(customerRequest.getIssue()).body(commentBody).publicComment(attachmentCreateDTO.get_public().booleanValue()).temporaryAttachmentIds(this.toTemporaryAttachmentIds(attachmentCreateDTO.getTemporaryAttachmentIds())).build();
    }

    private List<TemporaryAttachmentId> toTemporaryAttachmentIds(List<String> temporaryAttachmentIds) {
        if (Optional.ofNullable(temporaryAttachmentIds).isPresent()) {
            return FpKit.map(temporaryAttachmentIds, TemporaryAttachmentId::fromString);
        }
        return Collections.emptyList();
    }

    private io.atlassian.fugue.Either<AnError, CustomerRequest> getCustomerRequest(ApplicationUser user, String issueIdOrKey) {
        CustomerRequestQuery.Builder queryBuilder = this.serviceDeskCustomerRequestService.newQueryBuilder();
        return Steps.begin(this.issueIdOrKeyConverter.toIssueId(issueIdOrKey)).then(id -> StepsConverters.newerEither((Either)this.serviceDeskCustomerRequestService.getCustomerRequests(user, queryBuilder.issue(id).build()).map(PagedResponse::findFirst))).then((id, crOpt) -> Eithers.cond((boolean)crOpt.isPresent(), (Object)this.requestNotFound(), crOpt.get())).yield((id, crOpt, cr) -> cr);
    }

    private AnError requestNotFound() {
        return this.errorResultHelper.notFound404("sd.request.not.found", new Object[0]).build();
    }
}

