/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.info.PublicSoftwareInfo;
import com.atlassian.servicedesk.api.info.ServiceDeskSoftwareInfoService;
import com.atlassian.servicedesk.api.rest.annotations.PublicRestApi;
import com.atlassian.servicedesk.api.rest.dto.domain.info.SoftwareInfoDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.info.SoftwareInfoDTOFactory;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="info")
public class SoftwareInfoResource
extends CommonResource {
    private final ServiceDeskSoftwareInfoService serviceDeskSoftwareInfoService;
    private final SoftwareInfoDTOFactory softwareInfoDTOFactory;

    public SoftwareInfoResource(ServiceDeskSoftwareInfoService serviceDeskSoftwareInfoService, JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory, SoftwareInfoDTOFactory softwareInfoDTOFactory) {
        super(jiraAuthenticationContext, responseFactory);
        this.serviceDeskSoftwareInfoService = serviceDeskSoftwareInfoService;
        this.softwareInfoDTOFactory = softwareInfoDTOFactory;
    }

    @GET
    @ResponseType(value=SoftwareInfoDTO.class, status=200)
    @PublicRestApi
    public Response getInfo() {
        PublicSoftwareInfo softwareInfo = this.serviceDeskSoftwareInfoService.getSoftwareInfo(this.user());
        return this.responseFactory.entityResponse(softwareInfo, this.softwareInfoDTOFactory.toDTO(this.user()));
    }
}

