/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.fugue.Either;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeQuery;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.api.rest.annotations.PublicRestApi;
import com.atlassian.servicedesk.api.rest.annotations.RunOutOfCustomerContext;
import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.RequestTypeCreateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.RequestTypeDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.RequestTypeDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.RestPagedRequest;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.resource.assembler.RequestTypeAssembler;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import java.util.function.Function;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="servicedesk/{serviceDeskId}/requesttype")
public class RequestTypeResource
extends CommonResource {
    private final RequestTypeService requestTypeService;
    private final RequestTypeDTOFactory requestTypeDTOFactory;
    private final RequestTypeAssembler requestTypeAssembler;

    public RequestTypeResource(JiraAuthenticationContext jiraAuthenticationContext, RequestTypeService requestTypeService, ResponseFactory responseFactory, RequestTypeDTOFactory requestTypeDTOFactory, RequestTypeAssembler requestTypeAssembler) {
        super(jiraAuthenticationContext, responseFactory);
        this.requestTypeService = requestTypeService;
        this.requestTypeDTOFactory = requestTypeDTOFactory;
        this.requestTypeAssembler = requestTypeAssembler;
    }

    @GET
    @ResponseType(value=PagedDTO.class, genericTypes={RequestTypeDTO.class}, status=200)
    @PublicRestApi
    public Response getRequestTypes(@PathParam(value="serviceDeskId") Integer serviceDeskId, @QueryParam(value="groupId") Integer groupId, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        RequestTypeQuery query = this.requestTypeService.newQueryBuilder().serviceDesk(serviceDeskId).group(groupId).pagedRequest(RestPagedRequest.fromQueryParams(start, limit)).build();
        io.atlassian.fugue.Either result = StepsConverters.newerEither((Either)this.requestTypeService.getRequestTypes(this.user(), query));
        return this.responseFactory.pagedReponse(result, this.requestTypeDTOFactory.dtoMapper(serviceDeskId));
    }

    @GET
    @Path(value="{requestTypeId}")
    @ResponseType(value=RequestTypeDTO.class)
    @PublicRestApi
    public Response getRequestTypeById(@PathParam(value="serviceDeskId") Integer serviceDeskId, @PathParam(value="requestTypeId") Integer requestTypeId) {
        RequestTypeQuery query = this.requestTypeService.newQueryBuilder().serviceDesk(serviceDeskId).requestType(requestTypeId).build();
        io.atlassian.fugue.Either result = StepsConverters.newerEither((Either)this.requestTypeService.getRequestTypes(this.user(), query)).map(this.findFirst());
        return this.responseFactory.entityResponse(result, this.requestTypeDTOFactory.dtoMapper(serviceDeskId));
    }

    @POST
    @ExperimentalApi
    @RunOutOfCustomerContext
    public Response createRequestType(@PathParam(value="serviceDeskId") Integer serviceDeskId, RequestTypeCreateDTO createDTO) {
        return this.requestTypeAssembler.createRequestType(this.user(), serviceDeskId, createDTO);
    }

    private Function<PagedResponse<RequestType>, RequestType> findFirst() {
        return input -> (RequestType)input.findFirst().get();
    }
}

