/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.rest.annotations.PublicRestApi;
import com.atlassian.servicedesk.api.rest.dto.domain.request.status.CustomerRequestStatusDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.request.status.CustomerRequestStatusDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.RestPagedRequest;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.resource.assembler.CustomerRequestAssembler;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import io.atlassian.fugue.Either;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="request/{issueIdOrKey}/status")
public class RequestStatusResource
extends CommonResource {
    private final CustomerRequestAssembler customerRequestAssembler;
    private final CustomerRequestStatusDTOFactory customerRequestStatusDTOFactory;

    public RequestStatusResource(JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory, CustomerRequestAssembler customerRequestAssembler, CustomerRequestStatusDTOFactory customerRequestStatusDTOFactory) {
        super(jiraAuthenticationContext, responseFactory);
        this.customerRequestAssembler = customerRequestAssembler;
        this.customerRequestStatusDTOFactory = customerRequestStatusDTOFactory;
    }

    @GET
    @ResponseType(value=PagedDTO.class, genericTypes={CustomerRequestStatusDTO.class}, status=200)
    @PublicRestApi
    public Response getCustomerRequestStatus(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        ApplicationUser loggedInUser = this.user();
        Either<AnError, PagedResponse<CustomerRequest.CustomerRequestStatus>> result = this.customerRequestAssembler.getCustomerRequestStatus(loggedInUser, issueIdOrKey, RestPagedRequest.fromQueryParams(start, limit));
        return this.responseFactory.pagedReponse(result, this.customerRequestStatusDTOFactory.withUser(loggedInUser));
    }
}

