/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.rest.annotations.PublicRestApi;
import com.atlassian.servicedesk.api.rest.dto.domain.sla.SlaInformationDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.sla.SlaInformationDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.resource.assembler.RequestSlaAssembler;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import io.atlassian.fugue.Option;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="request/{issueIdOrKey}/sla")
public class RequestSlaResource
extends CommonResource {
    private final RequestSlaAssembler slaAssembler;
    private final SlaInformationDTOFactory slaInformationDTOFactory;

    public RequestSlaResource(JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory, RequestSlaAssembler slaAssembler, SlaInformationDTOFactory dtoFactory) {
        super(jiraAuthenticationContext, responseFactory);
        this.slaAssembler = slaAssembler;
        this.slaInformationDTOFactory = dtoFactory;
    }

    @GET
    @ResponseType(value=PagedDTO.class, genericTypes={SlaInformationDTO.class}, status=200)
    @PublicRestApi
    public Response getSlaInformation(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        return this.responseFactory.pagedReponse(this.slaAssembler.getSlaInfo(this.user(), issueIdOrKey, this.pagedRequest(start, limit)), this.slaInformationDTOFactory.dtoMapper(this.user(), issueIdOrKey));
    }

    @GET
    @Path(value="{slaMetricId}")
    @ResponseType(value=SlaInformationDTO.class, status=200)
    @PublicRestApi
    public Response getSlaInformationById(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="slaMetricId") Long slaMetricId) {
        return this.responseFactory.entityResponse(this.slaAssembler.getSlaInfoById(this.user(), issueIdOrKey, (Option<Long>)Option.option((Object)slaMetricId)), this.slaInformationDTOFactory.dtoMapper(this.user(), issueIdOrKey));
    }
}

