/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.fugue.Either;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.request.participant.RequestParticipantService;
import com.atlassian.servicedesk.api.rest.annotations.PublicRestApi;
import com.atlassian.servicedesk.api.rest.dto.domain.request.participant.RequestParticipantUpdateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.user.UserDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.user.UserDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.resource.assembler.RequestParticipantParameterAssembler;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="request/{issueIdOrKey}/participant")
public class RequestParticipantResource
extends CommonResource {
    private final RequestParticipantService requestParticipantService;
    private final UserDTOFactory userDTOFactory;
    private final RequestParticipantParameterAssembler requestParticipantParameterAssembler;

    public RequestParticipantResource(JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory, RequestParticipantService requestParticipantService, UserDTOFactory userDTOFactory, RequestParticipantParameterAssembler requestParticipantParameterAssembler) {
        super(jiraAuthenticationContext, responseFactory);
        this.requestParticipantService = requestParticipantService;
        this.userDTOFactory = userDTOFactory;
        this.requestParticipantParameterAssembler = requestParticipantParameterAssembler;
    }

    @GET
    @ResponseType(value=PagedDTO.class, genericTypes={UserDTO.class}, status=200)
    @PublicRestApi
    public Response getRequestParticipants(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        return this.responseFactory.pagedReponse(this.getParticipant(issueIdOrKey, start, limit), this.userDTOFactory);
    }

    private io.atlassian.fugue.Either<AnError, PagedResponse<ApplicationUser>> getParticipant(String issueIdOrKey, Integer start, Integer limit) {
        return Steps.begin(this.requestParticipantParameterAssembler.createQueryParameters(issueIdOrKey, start, limit)).then(query -> StepsConverters.newerEither((Either)this.requestParticipantService.getRequestParticipants(this.user(), query))).yield((query, participants) -> participants);
    }

    @POST
    @RequestType(value=RequestParticipantUpdateDTO.class)
    @ResponseType(value=PagedDTO.class, genericTypes={UserDTO.class}, status=200)
    @PublicRestApi
    public Response addRequestParticipants(@PathParam(value="issueIdOrKey") String issueIdOrKey, RequestParticipantUpdateDTO updateDTO) {
        return this.responseFactory.pagedReponse(this.addParticipants(issueIdOrKey, updateDTO), this.userDTOFactory);
    }

    private io.atlassian.fugue.Either<AnError, PagedResponse<ApplicationUser>> addParticipants(String issueIdOrKey, RequestParticipantUpdateDTO updateDTO) {
        return Steps.begin(this.requestParticipantParameterAssembler.createUpdateParameters(this.user(), issueIdOrKey, updateDTO)).then(updateRequest -> StepsConverters.newerEither((Either)this.requestParticipantService.addRequestParticipants(this.user(), updateRequest))).yield((updateRequest, participants) -> participants);
    }

    @DELETE
    @RequestType(value=RequestParticipantUpdateDTO.class)
    @ResponseType(value=PagedDTO.class, genericTypes={UserDTO.class}, status=200)
    @PublicRestApi
    public Response removeRequestParticipants(@PathParam(value="issueIdOrKey") String issueIdOrKey, RequestParticipantUpdateDTO updateDTO) {
        return this.responseFactory.pagedReponse(this.doRemoveParticipants(issueIdOrKey, updateDTO), this.userDTOFactory);
    }

    private io.atlassian.fugue.Either<AnError, PagedResponse<ApplicationUser>> doRemoveParticipants(String issueIdOrKey, RequestParticipantUpdateDTO updateDTO) {
        return Steps.begin(this.requestParticipantParameterAssembler.createUpdateParameters(this.user(), issueIdOrKey, updateDTO)).then(updateRequest -> StepsConverters.newerEither((Either)this.requestParticipantService.removeRequestParticipants(this.user(), updateRequest))).yield((updateRequest, participants) -> participants);
    }
}

