/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.rest.dto.domain.organization.OrganizationDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.organization.OrganizationDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.servicedesk.organization.OrganizationServiceDeskUpdateDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.RestPagedRequest;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.resource.assembler.OrganizationServiceDeskAssembler;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="servicedesk/{serviceDeskId}/organization")
public class OrganizationServiceDeskResource
extends CommonResource {
    private OrganizationServiceDeskAssembler organizationServiceDeskAssembler;
    private final OrganizationDTOFactory organizationDTOFactory;

    public OrganizationServiceDeskResource(JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory, OrganizationServiceDeskAssembler organizationServiceDeskAssembler, OrganizationDTOFactory organizationDTOFactory) {
        super(jiraAuthenticationContext, responseFactory);
        this.organizationServiceDeskAssembler = organizationServiceDeskAssembler;
        this.organizationDTOFactory = organizationDTOFactory;
    }

    @GET
    @ResponseType(value=OrganizationDTO.class)
    @ExperimentalApi
    public Response getOrganizations(@PathParam(value="serviceDeskId") Integer serviceDeskId, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        Either<AnError, PagedResponse<CustomerOrganization>> result = this.organizationServiceDeskAssembler.getOrganizationsInServiceDesk(this.user(), serviceDeskId, RestPagedRequest.fromQueryParams(start, limit));
        return this.responseFactory.pagedReponse(result, this.organizationDTOFactory);
    }

    @POST
    @RequestType(value=OrganizationServiceDeskUpdateDTO.class)
    @ExperimentalApi
    public Response addOrganization(@PathParam(value="serviceDeskId") Integer serviceDeskId, OrganizationServiceDeskUpdateDTO organizationServiceDeskUpdateDTO) {
        Either<AnError, Unit> result = this.organizationServiceDeskAssembler.addOrganizationToServiceDesk(this.user(), serviceDeskId, organizationServiceDeskUpdateDTO);
        return (Response)result.fold(this.responseFactory::error, unit -> ResponseFactory.noContent());
    }

    @DELETE
    @RequestType(value=OrganizationServiceDeskUpdateDTO.class)
    @ExperimentalApi
    public Response removeOrganization(@PathParam(value="serviceDeskId") Integer serviceDeskId, OrganizationServiceDeskUpdateDTO organizationServiceDeskUpdateDTO) {
        Either<AnError, Unit> result = this.organizationServiceDeskAssembler.removeOrganizationFromServiceDesk(this.user(), serviceDeskId, organizationServiceDeskUpdateDTO);
        return (Response)result.fold(this.responseFactory::error, unit -> ResponseFactory.noContent());
    }
}

