/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.rest.dto.domain.user.CustomerCreateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.user.UserDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.user.UserDTOFactory;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.resource.assembler.CustomerAssembler;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import com.atlassian.servicedesk.api.user.CheckedUser;
import io.atlassian.fugue.Either;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="customer")
public class CustomerResource
extends CommonResource {
    private final ResponseFactory responseFactory;
    private final CustomerAssembler customerAssembler;
    private final UserDTOFactory userDTOFactory;

    public CustomerResource(JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory, CustomerAssembler customerAssembler, UserDTOFactory userDTOFactory) {
        super(jiraAuthenticationContext, responseFactory);
        this.responseFactory = responseFactory;
        this.customerAssembler = customerAssembler;
        this.userDTOFactory = userDTOFactory;
    }

    @POST
    @ExperimentalApi
    @RequestType(value=CustomerCreateDTO.class)
    @ResponseType(value=UserDTO.class, status=201)
    public Response createCustomer(CustomerCreateDTO customerCreateDTO) {
        Either<AnError, CheckedUser> result = this.customerAssembler.createCustomer(this.user(), customerCreateDTO);
        return this.responseFactory.createdResponse(result.map(CheckedUser::forJIRA), this.userDTOFactory);
    }
}

