/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.fugue.Either;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.comment.ServiceDeskComment;
import com.atlassian.servicedesk.api.comment.ServiceDeskCommentService;
import com.atlassian.servicedesk.api.rest.annotations.PublicRestApi;
import com.atlassian.servicedesk.api.rest.dto.domain.comment.CommentCreateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.comment.CommentDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.comment.CommentDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.resource.assembler.ServiceDeskCommentParameterAssembler;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="request/{issueIdOrKey}/comment")
public class CommentResource
extends CommonResource {
    private final ServiceDeskCommentService serviceDeskCommentService;
    private final ServiceDeskCommentParameterAssembler serviceDeskCommentParameterAssembler;
    private final CommentDTOFactory commentDTOFactory;

    public CommentResource(JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory, ServiceDeskCommentService serviceDeskCommentService, ServiceDeskCommentParameterAssembler serviceDeskCommentParameterAssembler, CommentDTOFactory commentDTOFactory) {
        super(jiraAuthenticationContext, responseFactory);
        this.serviceDeskCommentService = serviceDeskCommentService;
        this.serviceDeskCommentParameterAssembler = serviceDeskCommentParameterAssembler;
        this.commentDTOFactory = commentDTOFactory;
    }

    @POST
    @RequestType(value=CommentCreateDTO.class)
    @ResponseType(value=CommentDTO.class, status=201)
    @PublicRestApi
    public Response createRequestComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, CommentCreateDTO commentCreateDTO) {
        io.atlassian.fugue.Either result = Steps.begin(this.serviceDeskCommentParameterAssembler.createCommentParameters(this.user(), issueIdOrKey, commentCreateDTO)).then(createParameters -> StepsConverters.newerEither((Either)this.serviceDeskCommentService.createServiceDeskComment(this.user(), createParameters))).yield((createParameters, serviceDeskComment) -> serviceDeskComment);
        return this.responseFactory.createdResponse(result, this.commentDTOFactory);
    }

    @GET
    @ResponseType(value=PagedDTO.class, genericTypes={CommentDTO.class}, status=200)
    @PublicRestApi
    public Response getRequestComments(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="public") Boolean publicComment, @QueryParam(value="internal") Boolean internalComment, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        io.atlassian.fugue.Either<AnError, PagedResponse<ServiceDeskComment>> result = this.serviceDeskCommentParameterAssembler.queryComments(this.user(), issueIdOrKey, publicComment, internalComment, start, limit);
        return this.responseFactory.pagedReponse(result, this.commentDTOFactory);
    }

    @GET
    @Path(value="{commentId}")
    @ResponseType(value=CommentDTO.class, status=200)
    @PublicRestApi
    public Response getRequestCommentById(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="commentId") Long commentId) {
        io.atlassian.fugue.Either<AnError, ServiceDeskComment> result = this.serviceDeskCommentParameterAssembler.getCommentById(this.user(), issueIdOrKey, commentId);
        return this.responseFactory.entityResponse(result, this.commentDTOFactory);
    }
}

