/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.jira.field.json;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.rest.dto.domain.organization.OrganizationDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.request.CustomerRequestDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.sla.SlaInformationDTOFactory;
import com.atlassian.servicedesk.api.rest.util.ErrorResponse;
import com.atlassian.servicedesk.api.sla.info.SlaInformation;
import com.atlassian.servicedesk.internal.spi.jira.field.json.FieldJsonBuilderService;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={FieldJsonBuilderService.class})
public class FieldJsonBuilderServiceImpl
implements FieldJsonBuilderService {
    private final CustomerRequestDTOFactory requestDTOFactory;
    private final SlaInformationDTOFactory slaInformationDTOFactory;
    private final OrganizationDTOFactory organizationDTOFactory;

    @Autowired
    public FieldJsonBuilderServiceImpl(CustomerRequestDTOFactory requestDTOFactory, SlaInformationDTOFactory slaInformationDTOFactory, OrganizationDTOFactory organizationDTOFactory) {
        this.requestDTOFactory = requestDTOFactory;
        this.slaInformationDTOFactory = slaInformationDTOFactory;
        this.organizationDTOFactory = organizationDTOFactory;
    }

    public FieldJsonRepresentation buildNullJson() {
        return this.fieldRepresentation(null);
    }

    public FieldJsonRepresentation buildErrorJson(AnError anError) {
        return this.fieldRepresentation(ErrorResponse.from(anError));
    }

    public FieldJsonRepresentation buildCustomerRequestJson(ApplicationUser user, CustomerRequest customerRequest) {
        return this.fieldRepresentation(this.requestDTOFactory.jiraFieldDtoMapper(user).apply(customerRequest));
    }

    public FieldJsonRepresentation buildSlaInformationJson(ApplicationUser user, Issue issue, SlaInformation slaInformation) {
        String requestIdOrKey = String.valueOf(issue.getId());
        return this.fieldRepresentation(this.slaInformationDTOFactory.dtoMapper(user, requestIdOrKey).apply(slaInformation));
    }

    public FieldJsonRepresentation buildCustomerOrganizationsJson(Collection<CustomerOrganization> customerOrganizations) {
        return this.fieldRepresentation(customerOrganizations.stream().map(this.organizationDTOFactory::toDTO).collect(Collectors.toList()));
    }

    private FieldJsonRepresentation fieldRepresentation(Object data) {
        return new FieldJsonRepresentation(new JsonData(data));
    }
}

