/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.examples;

import com.atlassian.servicedesk.api.rest.dto.domain.date.DurationDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.sla.SlaInformationCompletedCycleDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.sla.SlaInformationDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.sla.SlaInformationOngoingCycleDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.examples.ExampleHelper;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

public class SLAExamples {
    private static final String SLA_PATH = "request/101102/sla";
    private static final LocalDateTime START_DATETIME = LocalDateTime.of(2015, 10, 9, 10, 45, 23);
    public static final SlaInformationDTO EXAMPLE = SLAExamples.buildExample(10030L, "Time To First Response", START_DATETIME, Duration.ofHours(0L), 4);
    public static final PagedDTO EXAMPLE_PAGE = ExampleHelper.standardPagedExample(3, "request/101102/sla", new Object[0]).addValue(EXAMPLE).addValue(SLAExamples.buildExample(10040L, "Time To Resolution", START_DATETIME, Duration.ofHours(10L), 20)).addValue(SLAExamples.buildExample(10050L, "Time To Retrospective", START_DATETIME, Duration.ofHours(24L), 40)).build();

    private static SlaInformationDTO buildExample(long slaMetricId, String slaName, LocalDateTime startTime, Duration offset, int goalHours) {
        Duration goal = Duration.ofHours(goalHours);
        LocalDateTime completed1Start = startTime.plusHours(0L);
        LocalDateTime completed1Stop = completed1Start.plus(offset).plusMinutes(7L);
        LocalDateTime completed2Start = completed1Stop.plusDays(1L);
        LocalDateTime completed2Stop = completed2Start.plusHours(5L).plusMinutes(23L);
        LocalDateTime ongoingStart = completed2Stop.plusHours(3L);
        LocalDateTime ongoingNow = ongoingStart.plusHours(1L).plusMinutes(34L);
        return SlaInformationDTO.builder().setName(slaName).set_links(ExampleHelper.jsdRestApiExampleUri("request/101102/sla/{slaMetricId}").buildSelfLink(slaMetricId)).addCompletedCycle(SlaInformationCompletedCycleDTO.builder().setBreached(false).setElapsedTime(SLAExamples.elapsed(completed1Start, completed1Stop)).setGoalDuration(ExampleHelper.durationDTO(goal.toMillis())).setRemainingTime(SLAExamples.remaining(completed1Start, completed1Stop, goal)).setStartTime(ExampleHelper.dateDTO(completed1Start, "Yesterday")).setStopTime(ExampleHelper.dateDTO(completed1Stop, "Yesterday")).build()).addCompletedCycle(SlaInformationCompletedCycleDTO.builder().setBreached(true).setElapsedTime(SLAExamples.elapsed(completed2Start, completed2Stop)).setGoalDuration(ExampleHelper.durationDTO(goal.toMillis())).setRemainingTime(SLAExamples.remaining(completed2Start, completed2Stop, goal)).setStartTime(ExampleHelper.dateDTO(completed2Start, "Today")).setStopTime(ExampleHelper.dateDTO(completed2Stop, "Today")).build()).setOngoingCycle(SlaInformationOngoingCycleDTO.builder().setBreached(false).setPaused(false).setElapsedTime(SLAExamples.elapsed(ongoingStart, ongoingNow)).setGoalDuration(ExampleHelper.durationDTO(goal.toMillis())).setRemainingTime(SLAExamples.remaining(ongoingStart, ongoingNow, goal)).setStartTime(ExampleHelper.dateDTO(ongoingStart, "Today")).build()).build();
    }

    private static DurationDTO elapsed(LocalDateTime start, LocalDateTime stop) {
        return ExampleHelper.durationDTO(ChronoUnit.MILLIS.between(start, stop));
    }

    private static DurationDTO remaining(LocalDateTime start, LocalDateTime stop, Duration goal) {
        Long elapsed = ChronoUnit.MILLIS.between(start, stop);
        LocalDateTime target = start.plus(goal);
        LocalDateTime current = start.plus(elapsed, ChronoUnit.MILLIS);
        return SLAExamples.elapsed(current, target);
    }
}

