/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.examples;

import com.atlassian.servicedesk.api.rest.dto.domain.date.DateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.date.DurationDTO;
import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedLinkDTO;
import com.atlassian.servicedesk.api.rest.util.uri.UriKit;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.uri.UriTemplate;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class ExampleHelper {
    public static final String BASE_REST_EXAMPLE_URL = "http://host:port/context/rest/servicedeskapi";

    public static DurationDTO durationDTO(long durationMS) {
        Duration duration = Duration.ofMillis(durationMS);
        String friendly = "" + duration.toHours() + "h " + duration.toMinutes() + "m";
        return DurationDTO.builder().setMillis(durationMS).setFriendly(friendly).build();
    }

    public static DateDTO dateDTO(LocalDateTime dateTime, String friendlyPrefix) {
        OffsetDateTime offsetDateTime = OffsetDateTime.of(dateTime, ZoneOffset.ofHours(7));
        String iso = offsetDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ"));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(" HH:mm a");
        String friendly = friendlyPrefix + dateTime.format(formatter);
        String jira = offsetDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        long epochMillis = dateTime.toInstant(ZoneOffset.ofHours(7)).toEpochMilli();
        return DateDTO.builder().setIso8601(iso).setJira(jira).setFriendly(friendly).setEpochMillis(epochMillis).build();
    }

    public static DateDTO dateDTO(int year, int month, int dayOfMonth, int hour, int minute, String friendlyPrefix) {
        LocalDateTime dateTime = LocalDateTime.of(year, month, dayOfMonth, hour, minute);
        return ExampleHelper.dateDTO(dateTime, friendlyPrefix);
    }

    public static <T> PagedDTO.Builder<T> standardPagedExample(int pageSize, String entityPath, Object ... values) {
        return PagedDTO.builder().setLimit(pageSize).setStart(pageSize).setSize(pageSize).setIsLastPage(false).set_links(ExampleHelper.jsdRestApiExampleUri(entityPath).buildPagedLinks(pageSize, pageSize, values));
    }

    public static ExampleUriBuilder jsdRestApiExampleUri(String path) {
        return new ExampleUriBuilder().withPath(path);
    }

    public static String jiraRestApiExampleUri(String path, Object ... values) {
        String fullUri = UriKit.smooshPaths("http://host:port/context/rest/api/2", path);
        return new UriTemplate(fullUri).createURI(ExampleHelper.makeStr(values));
    }

    private static String[] makeStr(Object[] values) {
        String[] strArr = new String[values.length];
        for (int i = 0; i < strArr.length; ++i) {
            strArr[i] = String.valueOf(values[i]);
        }
        return strArr;
    }

    public static class ExampleUriBuilder {
        String path;

        public ExampleUriBuilder withPath(String path) {
            this.path = (String)Preconditions.checkNotNull((Object)path);
            return this;
        }

        URI buildURI(Object ... values) {
            Preconditions.checkNotNull((Object)this.path);
            String fullPath = UriKit.smooshPaths(ExampleHelper.BASE_REST_EXAMPLE_URL, this.path);
            String uriStr = new UriTemplate(fullPath).createURI(ExampleHelper.makeStr(values));
            return UriKit.toURI(uriStr);
        }

        URI buildPagedURI(int start, int limit, Object ... values) {
            Preconditions.checkNotNull((Object)this.path);
            String fullPath = UriKit.smooshPaths(ExampleHelper.BASE_REST_EXAMPLE_URL, this.path);
            fullPath = fullPath + "?start=" + start + "&limit=" + limit;
            String uriStr = new UriTemplate(fullPath).createURI(ExampleHelper.makeStr(values));
            return UriKit.toURI(uriStr);
        }

        SelfLinkDTO buildSelfLink(Object ... values) {
            return new SelfLinkDTO(this.buildURI(values));
        }

        PagedLinkDTO buildPagedLinks(int start, int limit, Object ... values) {
            return PagedLinkDTO.builder().setBase(UriKit.toURI(ExampleHelper.BASE_REST_EXAMPLE_URL)).setContext("context").setNext(this.buildPagedURI(start + limit, limit, values)).setPrev(this.buildPagedURI(start - limit, limit, values)).build();
        }
    }
}

