/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.examples;

import com.atlassian.servicedesk.api.rest.dto.domain.attachment.AttachmentCreateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.attachment.AttachmentCreateResultDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.attachment.AttachmentDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.attachment.AttachmentLinkDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.comment.AdditionalCommentDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.comment.CommentDTO;
import com.atlassian.servicedesk.api.rest.examples.ExampleHelper;
import com.atlassian.servicedesk.api.rest.examples.UserExamples;
import com.atlassian.servicedesk.api.rest.util.uri.UriKit;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class AttachmentExamples {
    private static final AdditionalCommentDTO ADDITIONAL_COMMENT_DTO = AdditionalCommentDTO.builder().setBody("Please find the screenshot and the log file attached.").build();
    public static final AttachmentCreateDTO ATTACHMENT_CREATE_DTO = AttachmentCreateDTO.builder().setAdditionalComment(ADDITIONAL_COMMENT_DTO).set_public(true).addTemporaryAttachmentId("temp910441317820424274").addTemporaryAttachmentId("temp3600755449679003114").build();
    private static final CommentDTO COMMENT_DTO = CommentDTO.builder().setId("1000").set_public(true).setBody("Please find the screenshot and the log file attached. !screenshot.png|thumbnail! [^log.txt] _(32 kB)_").setAuthor(UserExamples.FRED).setCreated(ExampleHelper.dateDTO(2015, 10, 9, 10, 22, "Today")).set_links(ExampleHelper.jsdRestApiExampleUri("request/{requestId}/comment/{commentId}").buildSelfLink(2000, 1000)).build();
    public static final AttachmentCreateResultDTO ATTACHMENT_DTO = AttachmentCreateResultDTO.builder().setComment(COMMENT_DTO).setAttachments(AttachmentExamples.getAttachments()).build();

    private static List<AttachmentDTO> getAttachments() {
        AttachmentDTO PNG = AttachmentDTO.builder().setAuthor(UserExamples.FRED).setCreated(ExampleHelper.dateDTO(2015, 10, 9, 10, 22, "Today")).setFilename("screenshot.png").setMimeType("image/png").setSize(23123L).set_links(AttachmentExamples.generateLinks("10000", "screenshot.png", true)).build();
        AttachmentDTO TXT = AttachmentDTO.builder().setAuthor(UserExamples.FRED).setCreated(ExampleHelper.dateDTO(2015, 10, 9, 10, 22, "Today")).setFilename("log.txt").setMimeType("text/plain").setSize(32132L).set_links(AttachmentExamples.generateLinks("10001", "log.txt", false)).build();
        return ImmutableList.of((Object)PNG, (Object)TXT);
    }

    private static AttachmentLinkDTO generateLinks(String id, String name, Boolean thumbnailable) {
        return AttachmentLinkDTO.builder().setJiraRest(UriKit.toURI("http://www.example.com/jira/rest/api/2/attachment/" + id)).setContent(UriKit.toURI("http://www.example.com/jira/servicedesk/customershim/secure/attachment/" + id + "/" + name)).setThumbnail(thumbnailable != false ? UriKit.toURI("http://www.example.com/jira/servicedesk/customershim/secure/thumbnail/" + id + "/_thumb_" + id + ".png") : null).build();
    }
}

