/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.paging;

import com.atlassian.servicedesk.api.rest.dto.DTOFactory;
import com.atlassian.servicedesk.api.rest.dto.Expandable;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedLinkDTO;
import com.atlassian.servicedesk.api.rest.util.uri.UriKit;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PagedDTOFactory {
    private static final Function<UriKit, URI> CURRENT_SELF_LINK = kit -> kit.getRequestUriBuilder().build(new Object[0]);
    private final UriKit uriKit;

    @Autowired
    public PagedDTOFactory(UriKit uriKit) {
        this.uriKit = uriKit;
    }

    public <S, T> Function<PagedResponse<S>, PagedDTO<T>> pageDtoMapper(DTOFactory<S, T> factory) {
        return this.pageDtoMapper(factory, CURRENT_SELF_LINK);
    }

    public <S, T> Function<PagedResponse<S>, PagedDTO<T>> pageDtoMapper(DTOFactory<S, T> factory, Function<UriKit, URI> selfLinkFunction) {
        return input -> this.pagedResponse((PagedResponse)input, factory, selfLinkFunction);
    }

    public <S, T> Function<PagedResponse<S>, PagedDTO<T>> pageDtoMapper(Function<S, T> mapper) {
        return this.pageDtoMapper(mapper, CURRENT_SELF_LINK);
    }

    public <S, T> Function<PagedResponse<S>, PagedDTO<T>> pageDtoMapper(Function<S, T> mapper, Function<UriKit, URI> selfLinkFunction) {
        return input -> this.pagedResponse((PagedResponse)input, mapper, selfLinkFunction);
    }

    private <S, T> PagedDTO<T> pagedResponse(PagedResponse<S> pagedResponse, DTOFactory<S, T> factory, Function<UriKit, URI> selfLinkFunction) {
        Preconditions.checkNotNull(pagedResponse);
        Preconditions.checkNotNull(factory);
        Function<Object, Object> mapper = factory::toDTO;
        return this.pagedResponse(pagedResponse, mapper, selfLinkFunction);
    }

    private <S, T> PagedDTO<T> pagedResponse(PagedResponse<S> pagedResponse, Function<S, T> mapper, Function<UriKit, URI> selfLinkFunction) {
        Preconditions.checkNotNull(pagedResponse);
        Preconditions.checkNotNull(mapper);
        PagedLinkDTO pagedLinkDTO = this.buildPagedLinks(pagedResponse, selfLinkFunction);
        List values = pagedResponse.map(mapper::apply).getResults();
        return PagedDTO.builder().set_links(pagedLinkDTO).setIsLastPage(!pagedResponse.hasNextPage()).setLimit(pagedResponse.getPagedRequest().getLimit()).setStart(pagedResponse.getPagedRequest().getStart()).setSize(pagedResponse.size()).setValues(values).setExpands(this.getExpands(values.stream().findFirst())).build();
    }

    private <T> List<String> getExpands(Optional<T> value) {
        return value.filter(c -> Expandable.class.isAssignableFrom(c.getClass())).map(i -> ((Expandable)i).getExpands()).orElse(null);
    }

    private <S> PagedLinkDTO buildPagedLinks(PagedResponse<S> pagedResponse, Function<UriKit, URI> selfLinkFunction) {
        URI baseUri = this.uriKit.getJIRABaseURI();
        URI selfURI = selfLinkFunction.apply(this.uriKit);
        String contextPath = this.uriKit.getContextPath();
        PagedRequest pagedRequest = pagedResponse.getPagedRequest();
        URI nextURI = null;
        URI prevURI = null;
        if (pagedResponse.hasNextPage()) {
            int nextStart = pagedRequest.getStart() + pagedRequest.getLimit();
            nextURI = UriBuilder.fromUri((URI)selfURI).replaceQueryParam("limit", new Object[]{pagedRequest.getLimit()}).replaceQueryParam("start", new Object[]{nextStart}).build(new Object[0]);
        }
        if (pagedRequest.getStart() > 0) {
            UriBuilder uriBuilder = UriBuilder.fromUri((URI)selfURI);
            int possiblePrev = pagedRequest.getStart() - pagedRequest.getLimit();
            if (possiblePrev < 0) {
                possiblePrev = 0;
                int limit = pagedRequest.getStart();
                uriBuilder.replaceQueryParam("limit", new Object[]{limit});
            } else {
                uriBuilder.replaceQueryParam("limit", new Object[]{pagedRequest.getLimit()});
            }
            prevURI = uriBuilder.replaceQueryParam("start", new Object[]{possiblePrev}).build(new Object[0]);
        }
        return PagedLinkDTO.builder().setBase(baseUri).setContext(contextPath).setSelf(selfURI).setNext(nextURI).setPrev(prevURI).build();
    }
}

