/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.links;

import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import com.atlassian.servicedesk.api.rest.util.uri.UriKit;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LinkFactory {
    private final UriKit uriKit;

    @Autowired
    public LinkFactory(UriKit uriKit) {
        this.uriKit = uriKit;
    }

    public LinkPart start() {
        return new LinkPart(this.uriKit.getBaseUriBuilder());
    }

    public LinkPart startAdmin() {
        return new LinkPart(this.uriKit.getAdminBaseUriBuilder());
    }

    public class LinkPart {
        private UriBuilder uriBuilder;

        public LinkPart(UriBuilder uriBuilder) {
            this.uriBuilder = uriBuilder;
        }

        public LinkPart queryParam(String name, Object ... values) throws IllegalArgumentException {
            this.uriBuilder = this.uriBuilder.queryParam(name, values);
            return this;
        }

        public LinkPart path(String path) throws IllegalArgumentException {
            this.uriBuilder = this.uriBuilder.path(path);
            return this;
        }

        public LinkPart segment(String ... segments) throws IllegalArgumentException {
            this.uriBuilder = this.uriBuilder.segment(segments);
            return this;
        }

        public SelfLinkDTO build(Object ... values) {
            URI self = this.buildUri(values);
            return new SelfLinkDTO(self);
        }

        public URI buildUri(Object ... values) {
            return this.uriBuilder.build(values);
        }
    }
}

