/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.requesttype.icon;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class RequestTypeIconLinkDTO {
    private final Map<String, URI> iconUrls;

    @JsonCreator
    public RequestTypeIconLinkDTO(@JsonProperty(value="iconUrls") Map<String, URI> iconUrls) {
        this.iconUrls = iconUrls != null ? ImmutableMap.copyOf(iconUrls) : null;
    }

    public Map<String, URI> getIconUrls() {
        return this.iconUrls;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RequestTypeIconLinkDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestTypeIconLinkDTO that = (RequestTypeIconLinkDTO)o;
        return Objects.equals(this.getIconUrls(), that.getIconUrls());
    }

    public int hashCode() {
        return Objects.hash(this.getIconUrls());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("iconUrls", this.getIconUrls()).toString();
    }

    public static final class Builder {
        private Map<String, URI> iconUrls = Maps.newHashMap();

        private Builder() {
        }

        private Builder(RequestTypeIconLinkDTO initialData) {
            this.iconUrls = Maps.newHashMap(initialData.getIconUrls());
        }

        public Builder setIconUrls(Map<String, URI> iconUrls) {
            this.iconUrls = iconUrls;
            return this;
        }

        public Builder addIconUrls(Map<String, URI> iconUrls) {
            this.iconUrls.putAll(iconUrls);
            return this;
        }

        public RequestTypeIconLinkDTO build() {
            return new RequestTypeIconLinkDTO(this.iconUrls);
        }
    }
}

