/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.requesttype;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.RequestTypeDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.icon.RequestTypeIconDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.icon.RequestTypeIconLinkDTO;
import com.atlassian.servicedesk.api.rest.dto.links.LinkFactory;
import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import com.atlassian.servicedesk.api.rest.util.uri.UriKit;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeDTOFactory {
    public static final String PAGE_PATH = "servicedesk/{serviceDeskId}/requesttype";
    public static final String SELF_PATH = "servicedesk/{serviceDeskId}/requesttype/{requestTypeId}";
    private final UriKit uriKit;
    private final LinkFactory linkFactory;

    @Autowired
    public RequestTypeDTOFactory(UriKit uriKit, LinkFactory linkFactory) {
        this.uriKit = uriKit;
        this.linkFactory = linkFactory;
    }

    public Function<RequestType, RequestTypeDTO> dtoMapper(int serviceDeskId) {
        return requestType -> {
            SelfLinkDTO link = this.linkFactory.start().path(SELF_PATH).build(serviceDeskId, requestType.getId());
            return RequestTypeDTO.builder().setId(String.valueOf(requestType.getId())).setName(requestType.getName()).setDescription(requestType.getDescription()).setHelpText(requestType.getHelpText()).setServiceDeskId(String.valueOf(serviceDeskId)).setIcon(this.buildIconDTO((RequestType)requestType)).setGroupIds(this.getGroupIds((RequestType)requestType)).set_links(link).build();
        };
    }

    private List<String> getGroupIds(RequestType requestType) {
        return requestType.getGroups().stream().map(group -> String.valueOf(group.getId())).collect(Collectors.toList());
    }

    private RequestTypeIconDTO buildIconDTO(RequestType requestType) {
        Long iconId = requestType.getIconId();
        RequestTypeIconLinkDTO iconLinkDTO = RequestTypeIconLinkDTO.builder().setIconUrls(this.getIconUrls(iconId, RequestTypeDTOFactory.getIconSizes())).build();
        return RequestTypeIconDTO.builder().setId(iconId.toString()).set_links(iconLinkDTO).build();
    }

    private Map<String, URI> getIconUrls(Long iconId, Set<Avatar.Size> sizes) {
        HashMap<String, URI> map = new HashMap<String, URI>();
        sizes.forEach(size -> {
            String sizeName = size.getPixels() + "x" + size.getPixels();
            URI uri = UriBuilder.fromUri((URI)this.uriKit.getJIRABaseURI()).path("secure").path("viewavatar").queryParam("avatarType", new Object[]{"SD_REQTYPE"}).queryParam("size", new Object[]{size.getParam()}).queryParam("avatarId", new Object[]{iconId}).build(new Object[0]);
            map.put(sizeName, uri);
        });
        return map;
    }

    public static Set<Avatar.Size> getIconSizes() {
        return ImmutableSet.of((Object)Avatar.Size.SMALL, (Object)Avatar.Size.NORMAL, (Object)Avatar.Size.MEDIUM, (Object)Avatar.Size.LARGE);
    }
}

