/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.requesttype;

import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.icon.RequestTypeIconDTO;
import com.atlassian.servicedesk.api.rest.dto.links.Linkable;
import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class RequestTypeDTO
implements Linkable {
    private final String id;
    private final SelfLinkDTO _links;
    private final String name;
    private final String description;
    private final String helpText;
    private final String serviceDeskId;
    private final List<String> groupIds;
    private final RequestTypeIconDTO icon;

    @JsonCreator
    public RequestTypeDTO(@JsonProperty(value="id") String id, @JsonProperty(value="_links") SelfLinkDTO _links, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="helpText") String helpText, @JsonProperty(value="serviceDeskId") String serviceDeskId, @JsonProperty(value="groupIds") List<String> groupIds, @JsonProperty(value="icon") RequestTypeIconDTO icon) {
        this.id = id;
        this._links = _links;
        this.name = name;
        this.description = description;
        this.helpText = helpText;
        this.serviceDeskId = serviceDeskId;
        this.groupIds = groupIds != null ? ImmutableList.copyOf(groupIds) : null;
        this.icon = icon;
    }

    public String getId() {
        return this.id;
    }

    public SelfLinkDTO get_links() {
        return this._links;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public String getServiceDeskId() {
        return this.serviceDeskId;
    }

    public List<String> getGroupIds() {
        return this.groupIds;
    }

    public RequestTypeIconDTO getIcon() {
        return this.icon;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RequestTypeDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestTypeDTO that = (RequestTypeDTO)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.get_links(), that.get_links()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getHelpText(), that.getHelpText()) && Objects.equals(this.getServiceDeskId(), that.getServiceDeskId()) && Objects.equals(this.getGroupIds(), that.getGroupIds()) && Objects.equals(this.getIcon(), that.getIcon());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.get_links(), this.getName(), this.getDescription(), this.getHelpText(), this.getServiceDeskId(), this.getGroupIds(), this.getIcon());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("_links", (Object)this.get_links()).add("name", (Object)this.getName()).add("description", (Object)this.getDescription()).add("helpText", (Object)this.getHelpText()).add("serviceDeskId", (Object)this.getServiceDeskId()).add("groupIds", this.getGroupIds()).add("icon", (Object)this.getIcon()).toString();
    }

    public static final class Builder {
        private String id;
        private SelfLinkDTO _links;
        private String name;
        private String description;
        private String helpText;
        private String serviceDeskId;
        private List<String> groupIds = Lists.newArrayList();
        private RequestTypeIconDTO icon;

        private Builder() {
        }

        private Builder(RequestTypeDTO initialData) {
            this.id = initialData.getId();
            this._links = initialData.get_links();
            this.name = initialData.getName();
            this.description = initialData.getDescription();
            this.helpText = initialData.getHelpText();
            this.serviceDeskId = initialData.getServiceDeskId();
            this.groupIds = Lists.newArrayList(initialData.getGroupIds());
            this.icon = initialData.getIcon();
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder set_links(SelfLinkDTO _links) {
            this._links = _links;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setHelpText(String helpText) {
            this.helpText = helpText;
            return this;
        }

        public Builder setServiceDeskId(String serviceDeskId) {
            this.serviceDeskId = serviceDeskId;
            return this;
        }

        public Builder setGroupIds(List<String> groupIds) {
            this.groupIds = groupIds;
            return this;
        }

        public Builder addGroupId(String groupId) {
            this.groupIds.add(groupId);
            return this;
        }

        public Builder addGroupIds(Iterable<String> groupIds) {
            for (String groupId : groupIds) {
                this.addGroupId(groupId);
            }
            return this;
        }

        public Builder setIcon(RequestTypeIconDTO icon) {
            this.icon = icon;
            return this;
        }

        public RequestTypeDTO build() {
            return new RequestTypeDTO(this.id, this._links, this.name, this.description, this.helpText, this.serviceDeskId, this.groupIds, this.icon);
        }
    }
}

