/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.request.status;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.rest.dto.domain.date.DateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.date.DateDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.request.status.CustomerRequestStatusDTO;
import java.util.Date;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerRequestStatusDTOFactory {
    public static String SELF_PATH = "request/{requestId}/status";
    private DateDTOFactory dateDTOFactory;

    @Autowired
    public CustomerRequestStatusDTOFactory(DateDTOFactory dateDTOFactory) {
        this.dateDTOFactory = dateDTOFactory;
    }

    public CustomerRequestStatusDTO toDTO(ApplicationUser user, CustomerRequest.CustomerRequestStatus from) {
        return Optional.ofNullable(from).map(f -> {
            DateDTO statusDate = Optional.ofNullable(f.statusInstant()).map(d -> this.dateDTOFactory.toDTO(user, Date.from(d))).orElse(null);
            return CustomerRequestStatusDTO.builder().setStatus(f.status()).setStatusDate(statusDate).build();
        }).orElse(null);
    }

    public Function<CustomerRequest.CustomerRequestStatus, CustomerRequestStatusDTO> withUser(ApplicationUser user) {
        return input -> this.toDTO(user, (CustomerRequest.CustomerRequestStatus)input);
    }
}

