/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.request;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.field.CustomerRequestCreateMeta;
import com.atlassian.servicedesk.api.field.RequestTypeFieldQuery;
import com.atlassian.servicedesk.api.field.RequestTypeFieldService;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.request.participant.RequestParticipantQuery;
import com.atlassian.servicedesk.api.request.participant.RequestParticipantService;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeQuery;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.api.rest.dto.domain.date.DateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.date.DateDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.request.CustomerRequestDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.request.CustomerRequestFieldValueDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.request.CustomerRequestJiraFieldDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.request.CustomerRequestLinkDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.request.status.CustomerRequestStatusDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.request.status.CustomerRequestStatusDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.RequestTypeDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.RequestTypeDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.servicedesk.ServiceDeskDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.servicedesk.ServiceDeskDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.sla.SlaInformationDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.sla.SlaInformationDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.user.UserDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.user.UserDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.links.LinkFactory;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.paging.RestPagedRequest;
import com.atlassian.servicedesk.api.rest.resource.assembler.CustomerRequestAssembler;
import com.atlassian.servicedesk.api.rest.resource.assembler.RequestSlaAssembler;
import com.atlassian.servicedesk.api.rest.util.uri.KnownUriPaths;
import com.atlassian.servicedesk.api.rest.util.uri.UriKit;
import com.atlassian.servicedesk.api.sla.info.SlaInformation;
import com.atlassian.servicedesk.api.util.expansion.Expansions;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerRequestDTOFactory {
    public static final List<String> REQUEST_EXPANSIONS = Arrays.asList("participant", "status", "sla", "requestType", "serviceDesk");
    private final LinkFactory linkFactory;
    private final UriKit uriKit;
    private final UserDTOFactory userDTOFactory;
    private final PermissionManager permissionManager;
    private final RequestTypeService requestTypeService;
    private final RequestTypeDTOFactory requestTypeDTOFactory;
    private final CustomerRequestStatusDTOFactory customerRequestStatusDTOFactory;
    private final ServiceDeskService serviceDeskService;
    private final ServiceDeskDTOFactory serviceDeskDTOFactory;
    private final DateDTOFactory dateDTOFactory;
    private final RequestParticipantService requestParticipantService;
    private final CustomerContextService customerContextService;
    private final RequestTypeFieldService requestTypeFieldService;
    private final FieldManager fieldManager;
    private final CustomerRequestAssembler customerRequestAssembler;
    private final RequestSlaAssembler requestSlaAssembler;
    private final SlaInformationDTOFactory slaInformationDTOFactory;
    private final PagedDTOFactory pagedDTOFactory;

    @Autowired
    public CustomerRequestDTOFactory(LinkFactory linkFactory, UriKit uriKit, UserDTOFactory userDTOFactory, PermissionManager permissionManager, RequestTypeService requestTypeService, RequestTypeDTOFactory requestTypeDTOFactory, CustomerRequestStatusDTOFactory customerRequestStatusDTOFactory, ServiceDeskService serviceDeskService, ServiceDeskDTOFactory serviceDeskDTOFactory, DateDTOFactory dateDTOFactory, RequestParticipantService requestParticipantService, CustomerContextService customerContextService, RequestTypeFieldService requestTypeFieldService, FieldManager fieldManager, CustomerRequestAssembler customerRequestAssembler, RequestSlaAssembler requestSlaAssembler, SlaInformationDTOFactory slaInformationDTOFactory, PagedDTOFactory pagedDTOFactory) {
        this.linkFactory = linkFactory;
        this.uriKit = uriKit;
        this.userDTOFactory = userDTOFactory;
        this.permissionManager = permissionManager;
        this.requestTypeService = requestTypeService;
        this.requestTypeDTOFactory = requestTypeDTOFactory;
        this.customerRequestStatusDTOFactory = customerRequestStatusDTOFactory;
        this.serviceDeskService = serviceDeskService;
        this.serviceDeskDTOFactory = serviceDeskDTOFactory;
        this.dateDTOFactory = dateDTOFactory;
        this.requestParticipantService = requestParticipantService;
        this.customerContextService = customerContextService;
        this.requestTypeFieldService = requestTypeFieldService;
        this.fieldManager = fieldManager;
        this.customerRequestAssembler = customerRequestAssembler;
        this.requestSlaAssembler = requestSlaAssembler;
        this.slaInformationDTOFactory = slaInformationDTOFactory;
        this.pagedDTOFactory = pagedDTOFactory;
    }

    public Function<CustomerRequest, CustomerRequestDTO> dtoMapper(ApplicationUser loggedInUser, Expansions expansions) {
        return from -> {
            Issue issue = from.getIssue();
            UserDTO reporter = this.userDTOFactory.toDTO(issue.getReporterUser());
            DateDTO createDate = this.dateDTOFactory.toDTO(loggedInUser, (Date)from.getIssue().getCreated());
            RequestTypeDTO requestType = this.expand(expansions.canExpand("requestType"), () -> this.getRequestType(loggedInUser, (CustomerRequest)from));
            ServiceDeskDTO serviceDesk = this.expand(expansions.canExpand("serviceDesk"), () -> this.getServiceDesk(loggedInUser, (CustomerRequest)from));
            PagedDTO slaInformation = this.expand(expansions.canExpand("sla"), () -> this.expandSlaInfo(loggedInUser, (CustomerRequest)from));
            PagedDTO status = this.expand(expansions.canExpand("status"), () -> this.expandRequestStatus(loggedInUser, (CustomerRequest)from));
            PagedDTO participants = this.expand(expansions.canExpand("participant"), () -> this.expandParticipants(loggedInUser, (CustomerRequest)from));
            CustomerRequestStatusDTO currentStatus = this.customerRequestStatusDTOFactory.toDTO(loggedInUser, from.currentStatus());
            List<CustomerRequestFieldValueDTO> fieldValues = this.getFieldValues(loggedInUser, (CustomerRequest)from);
            return CustomerRequestDTO.builder().setIssueId(String.valueOf(issue.getId())).setIssueKey(issue.getKey()).setRequestFieldValues(fieldValues).setCurrentStatus(currentStatus).set_links(this.getLinks(loggedInUser, from.getServiceDeskId(), issue)).setReporter(reporter).setRequestTypeId(String.valueOf(from.getRequestTypeId())).setServiceDeskId(String.valueOf(from.getServiceDeskId())).setCreatedDate(createDate).setIssueTypeId(issue.getIssueTypeId()).setProjectId(String.valueOf(issue.getProjectId())).setRequestType(requestType).setServiceDesk(serviceDesk).setParticipants(participants).setSla(slaInformation).setStatus(status).setExpands(REQUEST_EXPANSIONS).build();
        };
    }

    public Function<CustomerRequest, CustomerRequestJiraFieldDTO> jiraFieldDtoMapper(ApplicationUser loggedInUser) {
        return customerRequest -> {
            RequestTypeDTO requestType = this.getRequestType(loggedInUser, (CustomerRequest)customerRequest);
            CustomerRequestStatusDTO currentStatus = this.customerRequestStatusDTOFactory.toDTO(loggedInUser, customerRequest.currentStatus());
            CustomerRequestLinkDTO links = this.getLinks(loggedInUser, customerRequest.getServiceDeskId(), customerRequest.getIssue());
            return CustomerRequestJiraFieldDTO.builder().setRequestType(requestType).setCurrentStatus(currentStatus).set_links(links).build();
        };
    }

    private CustomerRequestLinkDTO getLinks(ApplicationUser loggedInUser, int serviceDeskId, Issue issue) {
        URI self = this.linkFactory.start().path("request/{requestId}").buildUri(issue.getId());
        URI web = UriBuilder.fromUri((URI)this.uriKit.getJIRABaseURI()).path("servicedesk/customer/portal/{serviceDeskId}/{issueKey}").build(new Object[]{serviceDeskId, issue.getKey()});
        URI jiraRest = null;
        if (this.canAccessJira(loggedInUser, issue)) {
            jiraRest = UriBuilder.fromUri((URI)this.uriKit.getJIRABaseURI()).path("rest/api/2/issue/{requestId}").build(new Object[]{issue.getId()});
        }
        return CustomerRequestLinkDTO.builder().setSelf(self).setWeb(web).setJiraRest(jiraRest).build();
    }

    private boolean canAccessJira(ApplicationUser loggedInUser, Issue issue) {
        return (Boolean)this.customerContextService.runOutOfCustomerContext(() -> this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, loggedInUser));
    }

    private RequestTypeDTO getRequestType(ApplicationUser user, CustomerRequest customerRequest) {
        RequestTypeQuery query = this.requestTypeService.newQueryBuilder().serviceDesk(Integer.valueOf(customerRequest.getServiceDeskId())).requestType(Integer.valueOf(customerRequest.getRequestTypeId())).build();
        return ((Optional)this.requestTypeService.getRequestTypes(user, query).map(PagedResponse::findFirst).fold(error -> Optional.empty(), Functions.identity())).map(rt -> this.requestTypeDTOFactory.dtoMapper(customerRequest.getServiceDeskId()).apply((RequestType)rt)).orElse(null);
    }

    private ServiceDeskDTO getServiceDesk(ApplicationUser user, CustomerRequest customerRequest) {
        return (ServiceDeskDTO)this.serviceDeskService.getServiceDeskById(user, (long)customerRequest.getServiceDeskId()).map(this.serviceDeskDTOFactory::toDTO).fold(error -> null, sd -> sd);
    }

    private PagedDTO<UserDTO> expandParticipants(ApplicationUser loggedInUser, CustomerRequest customerRequest) {
        RequestParticipantQuery query = this.requestParticipantService.newQueryBuilder().customerRequest(customerRequest.getIssue().getId()).build();
        PagedResponse pagedResponse = (PagedResponse)this.requestParticipantService.getRequestParticipants(loggedInUser, query).getOrNull();
        return this.toPagedDTO(pagedResponse, this.userDTOFactory::toDTO, KnownUriPaths.participantsLink(customerRequest.getIssue().getKey()));
    }

    private PagedDTO<SlaInformationDTO> expandSlaInfo(ApplicationUser user, CustomerRequest customerRequest) {
        String issueIdOrKey = String.valueOf(customerRequest.getIssue().getId());
        PagedResponse pagedResponse = (PagedResponse)this.requestSlaAssembler.getSlaInfo(user, issueIdOrKey, RestPagedRequest.defaultPage()).getOrNull();
        return this.toPagedDTO(pagedResponse, pr -> this.slaInformationDTOFactory.dtoMapper(user, issueIdOrKey).apply((SlaInformation)pr), KnownUriPaths.slaLink(customerRequest.getIssue().getKey()));
    }

    private PagedDTO<CustomerRequestStatusDTO> expandRequestStatus(ApplicationUser loggedInUser, CustomerRequest customerRequest) {
        PagedResponse pagedResponse = (PagedResponse)this.customerRequestAssembler.getCustomerRequestStatus(loggedInUser, customerRequest).getOrNull();
        return this.toPagedDTO(pagedResponse, status -> this.customerRequestStatusDTOFactory.toDTO(loggedInUser, (CustomerRequest.CustomerRequestStatus)status), KnownUriPaths.statusLink(customerRequest.getIssue().getKey()));
    }

    private List<CustomerRequestFieldValueDTO> getFieldValues(ApplicationUser loggedInUser, CustomerRequest customerRequest) {
        RequestTypeFieldQuery query = this.requestTypeFieldService.newQueryBuilder().serviceDesk(customerRequest.getServiceDeskId()).requestType(customerRequest.getRequestTypeId()).build();
        List fields = (List)this.requestTypeFieldService.getCustomerRequestCreateMeta(loggedInUser, query).fold(error -> Collections.emptyList(), CustomerRequestCreateMeta::requestTypeFields);
        Issue issue = customerRequest.getIssue();
        List values = Lists.transform((List)fields, f -> {
            String fieldId = f.fieldId().value();
            Field field = this.fieldManager.getField(fieldId);
            if (RestAwareField.class.isAssignableFrom(field.getClass())) {
                FieldJsonRepresentation jsonData = ((RestAwareField)field).getJsonFromIssue(issue, true, null);
                Optional<Object> data = Optional.empty();
                Optional<Object> renderedData = Optional.empty();
                if (Optional.ofNullable(jsonData).isPresent()) {
                    data = Optional.ofNullable(jsonData.getStandardData());
                    renderedData = Optional.ofNullable(jsonData.getRenderedData());
                }
                CustomerRequestFieldValueDTO value = CustomerRequestFieldValueDTO.builder().setFieldId(fieldId).setLabel(f.name()).setValue(data.map(JsonData::getData).orElse(null)).setRenderedValue(renderedData.map(JsonData::getData).orElse(null)).build();
                return Optional.of(value);
            }
            return Optional.empty();
        });
        return values.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private <DTO, T> PagedDTO<DTO> toPagedDTO(PagedResponse<T> pagedResponse, Function<T, DTO> mapper, Function<UriKit, URI> selfLinkFunction) {
        if (pagedResponse == null) {
            return null;
        }
        Function function = this.pagedDTOFactory.pageDtoMapper(io.atlassian.fugue.Functions.identity(), selfLinkFunction);
        return function.apply(pagedResponse.map(mapper::apply));
    }

    private <T> T expand(boolean canExpand, Supplier<T> supplier) {
        return canExpand ? (T)supplier.get() : null;
    }
}

