/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.request;

import com.atlassian.servicedesk.api.rest.dto.Expandable;
import com.atlassian.servicedesk.api.rest.dto.domain.date.DateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.request.CustomerRequestFieldValueDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.request.CustomerRequestLinkDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.request.status.CustomerRequestStatusDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.RequestTypeDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.servicedesk.ServiceDeskDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.sla.SlaInformationDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.user.UserDTO;
import com.atlassian.servicedesk.api.rest.dto.links.Linkable;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect
@JsonIgnoreProperties(value={"issueTypeId", "projectId"})
public class CustomerRequestDTO
implements Linkable<CustomerRequestLinkDTO>,
Expandable {
    @JsonProperty(value="_expands")
    private final List<String> expands;
    private final String issueId;
    private final String issueKey;
    private final String requestTypeId;
    private final RequestTypeDTO requestType;
    private final String serviceDeskId;
    private final ServiceDeskDTO serviceDesk;
    private final DateDTO createdDate;
    @JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
    private final UserDTO reporter;
    private final List<CustomerRequestFieldValueDTO> requestFieldValues;
    private final CustomerRequestStatusDTO currentStatus;
    private final PagedDTO<CustomerRequestStatusDTO> status;
    private final PagedDTO<UserDTO> participants;
    private final PagedDTO<SlaInformationDTO> sla;
    private final CustomerRequestLinkDTO _links;
    private final String issueTypeId;
    private final String projectId;

    @JsonCreator
    public CustomerRequestDTO(@JsonProperty(value="_expands") List<String> expands, @JsonProperty(value="issueId") String issueId, @JsonProperty(value="issueKey") String issueKey, @JsonProperty(value="requestTypeId") String requestTypeId, @JsonProperty(value="requestType") RequestTypeDTO requestType, @JsonProperty(value="serviceDeskId") String serviceDeskId, @JsonProperty(value="serviceDesk") ServiceDeskDTO serviceDesk, @JsonProperty(value="createdDate") DateDTO createdDate, @JsonProperty(value="reporter") UserDTO reporter, @JsonProperty(value="requestFieldValues") List<CustomerRequestFieldValueDTO> requestFieldValues, @JsonProperty(value="currentStatus") CustomerRequestStatusDTO currentStatus, @JsonProperty(value="status") PagedDTO<CustomerRequestStatusDTO> status, @JsonProperty(value="participants") PagedDTO<UserDTO> participants, @JsonProperty(value="sla") PagedDTO<SlaInformationDTO> sla, @JsonProperty(value="_links") CustomerRequestLinkDTO _links, @JsonProperty(value="issueTypeId") String issueTypeId, @JsonProperty(value="projectId") String projectId) {
        this.expands = expands != null ? ImmutableList.copyOf(expands) : null;
        this.issueId = issueId;
        this.issueKey = issueKey;
        this.requestTypeId = requestTypeId;
        this.requestType = requestType;
        this.serviceDeskId = serviceDeskId;
        this.serviceDesk = serviceDesk;
        this.createdDate = createdDate;
        this.reporter = reporter;
        this.requestFieldValues = requestFieldValues != null ? ImmutableList.copyOf(requestFieldValues) : null;
        this.currentStatus = currentStatus;
        this.status = status;
        this.participants = participants;
        this.sla = sla;
        this._links = _links;
        this.issueTypeId = issueTypeId;
        this.projectId = projectId;
    }

    @Override
    public List<String> getExpands() {
        return this.expands;
    }

    public String getIssueId() {
        return this.issueId;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public String getRequestTypeId() {
        return this.requestTypeId;
    }

    public RequestTypeDTO getRequestType() {
        return this.requestType;
    }

    public String getServiceDeskId() {
        return this.serviceDeskId;
    }

    public ServiceDeskDTO getServiceDesk() {
        return this.serviceDesk;
    }

    public DateDTO getCreatedDate() {
        return this.createdDate;
    }

    public UserDTO getReporter() {
        return this.reporter;
    }

    public List<CustomerRequestFieldValueDTO> getRequestFieldValues() {
        return this.requestFieldValues;
    }

    public CustomerRequestStatusDTO getCurrentStatus() {
        return this.currentStatus;
    }

    public PagedDTO<CustomerRequestStatusDTO> getStatus() {
        return this.status;
    }

    public PagedDTO<UserDTO> getParticipants() {
        return this.participants;
    }

    public PagedDTO<SlaInformationDTO> getSla() {
        return this.sla;
    }

    @Override
    public CustomerRequestLinkDTO get_links() {
        return this._links;
    }

    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CustomerRequestDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerRequestDTO that = (CustomerRequestDTO)o;
        return Objects.equals(this.getExpands(), that.getExpands()) && Objects.equals(this.getIssueId(), that.getIssueId()) && Objects.equals(this.getIssueKey(), that.getIssueKey()) && Objects.equals(this.getRequestTypeId(), that.getRequestTypeId()) && Objects.equals(this.getRequestType(), that.getRequestType()) && Objects.equals(this.getServiceDeskId(), that.getServiceDeskId()) && Objects.equals(this.getServiceDesk(), that.getServiceDesk()) && Objects.equals(this.getCreatedDate(), that.getCreatedDate()) && Objects.equals(this.getReporter(), that.getReporter()) && Objects.equals(this.getRequestFieldValues(), that.getRequestFieldValues()) && Objects.equals(this.getCurrentStatus(), that.getCurrentStatus()) && Objects.equals(this.getStatus(), that.getStatus()) && Objects.equals(this.getParticipants(), that.getParticipants()) && Objects.equals(this.getSla(), that.getSla()) && Objects.equals(this.get_links(), that.get_links()) && Objects.equals(this.getIssueTypeId(), that.getIssueTypeId()) && Objects.equals(this.getProjectId(), that.getProjectId());
    }

    public int hashCode() {
        return Objects.hash(this.getExpands(), this.getIssueId(), this.getIssueKey(), this.getRequestTypeId(), this.getRequestType(), this.getServiceDeskId(), this.getServiceDesk(), this.getCreatedDate(), this.getReporter(), this.getRequestFieldValues(), this.getCurrentStatus(), this.getStatus(), this.getParticipants(), this.getSla(), this.get_links(), this.getIssueTypeId(), this.getProjectId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("expands", this.getExpands()).add("issueId", (Object)this.getIssueId()).add("issueKey", (Object)this.getIssueKey()).add("requestTypeId", (Object)this.getRequestTypeId()).add("requestType", (Object)this.getRequestType()).add("serviceDeskId", (Object)this.getServiceDeskId()).add("serviceDesk", (Object)this.getServiceDesk()).add("createdDate", (Object)this.getCreatedDate()).add("reporter", (Object)this.getReporter()).add("requestFieldValues", this.getRequestFieldValues()).add("currentStatus", (Object)this.getCurrentStatus()).add("status", this.getStatus()).add("participants", this.getParticipants()).add("sla", this.getSla()).add("_links", (Object)this.get_links()).add("issueTypeId", (Object)this.getIssueTypeId()).add("projectId", (Object)this.getProjectId()).toString();
    }

    public static final class Builder {
        private List<String> expands = Lists.newArrayList();
        private String issueId;
        private String issueKey;
        private String requestTypeId;
        private RequestTypeDTO requestType;
        private String serviceDeskId;
        private ServiceDeskDTO serviceDesk;
        private DateDTO createdDate;
        private UserDTO reporter;
        private List<CustomerRequestFieldValueDTO> requestFieldValues = Lists.newArrayList();
        private CustomerRequestStatusDTO currentStatus;
        private PagedDTO<CustomerRequestStatusDTO> status;
        private PagedDTO<UserDTO> participants;
        private PagedDTO<SlaInformationDTO> sla;
        private CustomerRequestLinkDTO _links;
        private String issueTypeId;
        private String projectId;

        private Builder() {
        }

        private Builder(CustomerRequestDTO initialData) {
            this.expands = Lists.newArrayList(initialData.getExpands());
            this.issueId = initialData.getIssueId();
            this.issueKey = initialData.getIssueKey();
            this.requestTypeId = initialData.getRequestTypeId();
            this.requestType = initialData.getRequestType();
            this.serviceDeskId = initialData.getServiceDeskId();
            this.serviceDesk = initialData.getServiceDesk();
            this.createdDate = initialData.getCreatedDate();
            this.reporter = initialData.getReporter();
            this.requestFieldValues = Lists.newArrayList(initialData.getRequestFieldValues());
            this.currentStatus = initialData.getCurrentStatus();
            this.status = initialData.getStatus();
            this.participants = initialData.getParticipants();
            this.sla = initialData.getSla();
            this._links = initialData.get_links();
            this.issueTypeId = initialData.getIssueTypeId();
            this.projectId = initialData.getProjectId();
        }

        public Builder setExpands(List<String> expands) {
            this.expands = expands;
            return this;
        }

        public Builder addExpand(String expand) {
            this.expands.add(expand);
            return this;
        }

        public Builder addExpands(Iterable<String> expands) {
            for (String expand : expands) {
                this.addExpand(expand);
            }
            return this;
        }

        public Builder setIssueId(String issueId) {
            this.issueId = issueId;
            return this;
        }

        public Builder setIssueKey(String issueKey) {
            this.issueKey = issueKey;
            return this;
        }

        public Builder setRequestTypeId(String requestTypeId) {
            this.requestTypeId = requestTypeId;
            return this;
        }

        public Builder setRequestType(RequestTypeDTO requestType) {
            this.requestType = requestType;
            return this;
        }

        public Builder setServiceDeskId(String serviceDeskId) {
            this.serviceDeskId = serviceDeskId;
            return this;
        }

        public Builder setServiceDesk(ServiceDeskDTO serviceDesk) {
            this.serviceDesk = serviceDesk;
            return this;
        }

        public Builder setCreatedDate(DateDTO createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public Builder setReporter(UserDTO reporter) {
            this.reporter = reporter;
            return this;
        }

        public Builder setRequestFieldValues(List<CustomerRequestFieldValueDTO> requestFieldValues) {
            this.requestFieldValues = requestFieldValues;
            return this;
        }

        public Builder addRequestFieldValue(CustomerRequestFieldValueDTO requestFieldValue) {
            this.requestFieldValues.add(requestFieldValue);
            return this;
        }

        public Builder addRequestFieldValues(Iterable<CustomerRequestFieldValueDTO> requestFieldValues) {
            for (CustomerRequestFieldValueDTO requestFieldValue : requestFieldValues) {
                this.addRequestFieldValue(requestFieldValue);
            }
            return this;
        }

        public Builder setCurrentStatus(CustomerRequestStatusDTO currentStatus) {
            this.currentStatus = currentStatus;
            return this;
        }

        public Builder setStatus(PagedDTO<CustomerRequestStatusDTO> status) {
            this.status = status;
            return this;
        }

        public Builder setParticipants(PagedDTO<UserDTO> participants) {
            this.participants = participants;
            return this;
        }

        public Builder setSla(PagedDTO<SlaInformationDTO> sla) {
            this.sla = sla;
            return this;
        }

        public Builder set_links(CustomerRequestLinkDTO _links) {
            this._links = _links;
            return this;
        }

        public Builder setIssueTypeId(String issueTypeId) {
            this.issueTypeId = issueTypeId;
            return this;
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public CustomerRequestDTO build() {
            return new CustomerRequestDTO(this.expands, this.issueId, this.issueKey, this.requestTypeId, this.requestType, this.serviceDeskId, this.serviceDesk, this.createdDate, this.reporter, this.requestFieldValues, this.currentStatus, this.status, this.participants, this.sla, this._links, this.issueTypeId, this.projectId);
        }
    }
}

