/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.queue.admin;

import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.api.rest.dto.DTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.queue.admin.QueueCountDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.queue.admin.QueueSettingsDTO;
import com.atlassian.servicedesk.api.rest.dto.links.LinkFactory;
import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueueSettingsDTOFactory
implements DTOFactory<Project, QueueSettingsDTO> {
    private final QueueCountDTOFactory queueCountDTOFactory;
    private final LinkFactory linkFactory;

    @Autowired
    public QueueSettingsDTOFactory(QueueCountDTOFactory queueCountDTOFactory, LinkFactory linkFactory) {
        this.queueCountDTOFactory = queueCountDTOFactory;
        this.linkFactory = linkFactory;
    }

    @Override
    public QueueSettingsDTO toDTO(Project from) {
        SelfLinkDTO selfLink = this.linkFactory.startAdmin().path("queues/{projectKey}").build(from.getKey());
        return QueueSettingsDTO.builder().setQueueCount(this.queueCountDTOFactory.toDTO(from)).set_links(selfLink).build();
    }
}

