/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.queue.admin;

import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.api.rest.dto.DTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.queue.admin.QueueCountDTO;
import com.atlassian.servicedesk.internal.api.queues.CustomQueueCountState;
import com.atlassian.servicedesk.internal.api.queues.CustomQueueSettingsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueueCountDTOFactory
implements DTOFactory<Project, QueueCountDTO> {
    private final CustomQueueSettingsService customQueueSettingsService;

    @Autowired
    public QueueCountDTOFactory(CustomQueueSettingsService customQueueSettingsService) {
        this.customQueueSettingsService = customQueueSettingsService;
    }

    @Override
    public QueueCountDTO toDTO(Project from) {
        CustomQueueCountState customQueueCountState = this.customQueueSettingsService.getCustomQueueCountState(from);
        return QueueCountDTO.builder().setIncludeQueueCount(customQueueCountState.isInclude()).setUseCachedQueueCount(customQueueCountState.isUseCache()).build();
    }
}

