/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.queue;

import com.atlassian.servicedesk.api.queue.Queue;
import com.atlassian.servicedesk.api.rest.dto.DTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.queue.QueueDTO;
import com.atlassian.servicedesk.api.rest.dto.links.LinkFactory;
import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueueDTOFactory
implements DTOFactory<Queue, QueueDTO> {
    private final LinkFactory linkFactory;

    @Autowired
    public QueueDTOFactory(LinkFactory linkFactory) {
        this.linkFactory = linkFactory;
    }

    @Override
    public QueueDTO toDTO(Queue from) {
        SelfLinkDTO selfLink = this.linkFactory.start().path("servicedesk/{servicedeskId}/queue/{queueId}").build(from.getServiceDeskId(), from.getId());
        QueueDTO.Builder builder = QueueDTO.builder().setId(String.valueOf(from.getId())).setName(from.getName()).setJql(from.getJql()).setFields(from.getFields()).set_links(selfLink);
        if (from.getIssueCount().isPresent()) {
            builder.setIssueCount((Long)from.getIssueCount().get());
        }
        return builder.build();
    }
}

