/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.dto.domain.organization;

import com.atlassian.servicedesk.api.rest.dto.links.Linkable;
import com.atlassian.servicedesk.api.rest.dto.links.SelfLinkDTO;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class OrganizationDTO
implements Linkable {
    private final String id;
    private final String name;
    private final SelfLinkDTO _links;

    @JsonCreator
    public OrganizationDTO(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="_links") SelfLinkDTO _links) {
        this.id = id;
        this.name = name;
        this._links = _links;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public SelfLinkDTO get_links() {
        return this._links;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OrganizationDTO data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationDTO that = (OrganizationDTO)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.get_links(), that.get_links());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getName(), this.get_links());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("_links", (Object)this.get_links()).toString();
    }

    public static final class Builder {
        private String id;
        private String name;
        private SelfLinkDTO _links;

        private Builder() {
        }

        private Builder(OrganizationDTO initialData) {
            this.id = initialData.getId();
            this.name = initialData.getName();
            this._links = initialData.get_links();
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder set_links(SelfLinkDTO _links) {
            this._links = _links;
            return this;
        }

        public OrganizationDTO build() {
            return new OrganizationDTO(this.id, this.name, this._links);
        }
    }
}

